/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.rest;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.xstream.CiXStreamWriter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.ws.rs.core.MediaType;

public class FormatFactory {
    private static final StaxDriver STAX_DRIVER = new StaxDriver();

    public CiReader createCiReader(InputStream entityStream, MediaType mediaType) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return CiJsonReader.create(FormatFactory.toString(entityStream));
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            try {
                HierarchicalStreamReader reader = STAX_DRIVER.createReader(entityStream);
                return new CiXstreamReader(reader);
            }
            catch (StreamException e) {
                throw new IllegalArgumentException("Can't read content as XML", e);
            }
        }
        throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
    }

    public CiListReader createCiListReader(InputStream entityStream, MediaType mediaType) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return CiListJsonReader.create(FormatFactory.toString(entityStream));
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            try {
                HierarchicalStreamReader reader = STAX_DRIVER.createReader(entityStream);
                return new CiXstreamReader(reader);
            }
            catch (StreamException e) {
                throw new IllegalArgumentException("Can't read content as XML", e);
            }
        }
        throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
    }

    public CiWriter createCiWriter(MediaType mediaType) {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return new CiJsonWriter();
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return new CiXStreamWriter();
        }
        throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
    }

    public static String toString(InputStream in) throws IOException {
        String res = null;
        if (null == in) {
            throw new NullPointerException();
        }
        try (InputStreamReader isr = new InputStreamReader(in, Charset.forName("UTF-8"));){
            StringWriter sw = new StringWriter();
            char[] buf = new char[4096];
            int len = 0;
            while ((len = isr.read(buf)) != -1) {
                sw.write(buf, 0, len);
                sw.flush();
            }
            res = sw.toString();
        }
        return res;
    }
}

