/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshaller;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.xltype.serialization.xstream.Converters.writeConfigurationItem;


public class ConfigurationItemMarshallingStrategy extends ReferenceByXPathMarshallingStrategy {
    private int mode;

    public ConfigurationItemMarshallingStrategy(int mode) {
        super(mode);
        this.mode = mode;
    }

    @Override
    protected TreeMarshaller createMarshallingContext(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        return new ConfigurationItemMarshaller(writer, converterLookup, mapper, mode);
    }

    public static class ConfigurationItemMarshaller extends ReferenceByXPathMarshaller {
        public ConfigurationItemMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper, int mode) {
            super(writer, converterLookup, mapper, mode);
        }

        @Override
        public void start(Object item, DataHolder dataHolder) {
            if (item instanceof ConfigurationItem) {
                writeConfigurationItem(((ConfigurationItem) item), writer, this);
            } else {
                super.start(item, dataHolder);
            }
        }
    }
}
