/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;

public class StepStateJsonConverter extends JsonConverter<StepState> {

    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();

    public JsonWriter writeJsonObject(StepState step, JsonWriter writer) {
        writer.object();
        writer.key("state").value(step.getState());
        writer.key("failures").value(step.getFailureCount());
        writer.key("description").value(step.getDescription());
        if (step.getStartDate() != null) {
            writer.key("startDate").value(timeAdapter.marshal(step.getStartDate()));
        }
        if (step.getCompletionDate() != null) {
            writer.key("completionDate").value(timeAdapter.marshal(step.getCompletionDate()));
        }
        if (step.getLog() != null) {
            writer.key("log").value(step.getLog());
        }
        writer.endObject();

        return writer;
    }
}
