/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;

import static com.xebialabs.xltype.serialization.xstream.Converters.readList;


@XStreamProvider(tagName = "selectedDeployment", readable = SelectedDeployment.class)
public class SelectedDeploymentConverter implements Converter {

    public static final String DEPLOYABLE_IDS = "mapping-for-deployables";
    public static final String ID = "id";
    public static final String DEPLOYMENT = "deployment";

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SelectedDeployment selectedDeployment = (SelectedDeployment) source;
        writeDeployablesIds(writer, selectedDeployment);
        writeDeployment(writer, context, selectedDeployment);
    }

    private void writeDeployment(final HierarchicalStreamWriter writer, final MarshallingContext context, final SelectedDeployment selectedDeployment) {
        writer.startNode(DEPLOYMENT);
        context.convertAnother(selectedDeployment.getDeployment());
        writer.endNode();
    }

    private void writeDeployablesIds(final HierarchicalStreamWriter writer, final SelectedDeployment selectedDeployment) {
        if (!selectedDeployment.getSelectedDeployableIds().isEmpty()) {
            writer.startNode(DEPLOYABLE_IDS);
            for (String id : selectedDeployment.getSelectedDeployableIds()) {
                writer.startNode(ID);
                writer.setValue(id);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SelectedDeployment selectedDeployment = new SelectedDeployment();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (DEPLOYMENT.equals(reader.getNodeName())) {
                Deployment deployment = (Deployment) context.convertAnother(selectedDeployment, Deployment.class);
                selectedDeployment.setDeployment(deployment);
            } else if (DEPLOYABLE_IDS.equals(reader.getNodeName())) {
                selectedDeployment.setSelectedDeployableIds(readList(selectedDeployment, String.class, reader, context));
            }
            reader.moveUp();
        }
        return selectedDeployment;
    }

    @Override
    public boolean canConvert(Class type) {
        return SelectedDeployment.class.isAssignableFrom(type);
    }
}
