/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import java.util.regex.Pattern;

public class XmlSanitizer {

    Pattern xmlInvalidChars =
            Pattern.compile("[^"
                    + "\u0001-\uD7FF"
                    + "\uE000-\uFFFD"
                    + "\ud800\udc00-\udbff\udfff"
                    + "]+"
            );

    public String sanitize(final String content) {
        return xmlInvalidChars.matcher(content).replaceAll(" ");
    }
}
