/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.jdom;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemIdAndReferenceId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;
import com.xebialabs.deployit.plugin.api.udm.lookup.LookupValueKey;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.jdom.JdomWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiJdomWriter
implements CiWriter {
    private final JdomWriter jdomWriter;
    private Deque<Boolean> suppressListStack = new ArrayDeque<Boolean>();

    public CiJdomWriter() {
        this(new JdomWriter());
    }

    public CiJdomWriter(JdomWriter jdomWriter) {
        this.jdomWriter = jdomWriter;
        this.suppressListStack.push(false);
    }

    @Override
    public void startList() {
        if (this.suppressListStack.peek().booleanValue()) {
            return;
        }
        this.jdomWriter.element("list");
    }

    @Override
    public void endList() {
        if (this.suppressListStack.peek().booleanValue()) {
            return;
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void startCi(String type, String id) {
        this.jdomWriter.element(type).attribute("id", id);
    }

    @Override
    public void endCi() {
        this.jdomWriter.endElement();
    }

    @Override
    public void token(String token) {
        this.jdomWriter.attribute("token", token);
    }

    @Override
    public void ciAttributes(CiAttributes ciAttributes) {
        this.addStringAttribute("created-by", ciAttributes.getCreatedBy());
        this.addDateAttribute("created-at", ciAttributes.getCreatedAt());
        this.addStringAttribute("last-modified-by", ciAttributes.getLastModifiedBy());
        this.addDateAttribute("last-modified-at", ciAttributes.getLastModifiedAt());
        this.addStringAttribute("scm-traceability-data-id", ciAttributes.getScmTraceabilityDataId());
    }

    @Override
    public void ciFileAttribute(String file) {
        this.addStringAttribute("file", file);
    }

    private void addStringAttribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.jdomWriter.attribute(attrName, attrValue);
        }
    }

    private void addDateAttribute(String attrName, DateTime attrValue) {
        if (attrValue != null) {
            this.jdomWriter.attributeAsDate(attrName, attrValue);
        }
    }

    @Override
    public void startProperty(String name) {
        this.jdomWriter.element(name);
        this.suppressListStack.push(true);
    }

    @Override
    public void endProperty() {
        this.jdomWriter.endElement();
        this.suppressListStack.pop();
    }

    @Override
    public void valueAsString(Object value) {
        this.jdomWriter.value(value.toString());
    }

    @Override
    public void valuesAsStrings(Collection<?> values) {
        for (Object value : values) {
            this.jdomWriter.element("value").value(value.toString()).endElement();
        }
    }

    @Override
    public void mapAsStrings(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.jdomWriter.element("entry").attribute("key", entry.getKey().toString()).value(entry.getValue().toString()).endElement();
        }
    }

    @Override
    public void ciReference(String reference) {
        this.jdomWriter.attribute("ref", reference);
    }

    @Override
    public void ciReferences(Collection<String> references) {
        for (String reference : references) {
            this.jdomWriter.element("ci").attribute("ref", reference).endElement();
        }
    }

    @Override
    public void typedCiReference(ConfigurationItemId ci) {
        this.jdomWriter.element("ci");
        this.jdomWriter.attribute("ref", ci.getId());
        if (ci.getType() != null) {
            this.jdomWriter.attribute("type", ci.getType().toString());
        }
        if (ci instanceof ConfigurationItemIdAndReferenceId) {
            this.jdomWriter.attribute("reference-id", ((ConfigurationItemIdAndReferenceId)ci).getReferenceId());
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void typedCiReferences(Collection<? extends ConfigurationItemId> references) {
        this.jdomWriter.element("list");
        for (ConfigurationItemId configurationItemId : references) {
            this.typedCiReference(configurationItemId);
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void validationMessages(List<ValidationMessage> validations) {
        this.jdomWriter.element("validation-messages");
        for (ValidationMessage validation : validations) {
            this.jdomWriter.element("validation-message");
            this.jdomWriter.attribute("level", validation.getLevel().name());
            this.jdomWriter.attribute("ci", validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.jdomWriter.attribute("property", validation.getPropertyName());
            }
            this.jdomWriter.value(validation.getMessage());
            this.jdomWriter.endElement();
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void externalProperties(Map<String, ExternalProperty> externalProperties) {
        this.jdomWriter.element("external-properties");
        for (Map.Entry<String, ExternalProperty> entry : externalProperties.entrySet()) {
            this.jdomWriter.element(entry.getKey());
            ExternalProperty externalProperty = entry.getValue();
            if (externalProperty instanceof LookupValueKey) {
                LookupValueKey lookupValueKey = (LookupValueKey)externalProperty;
                this.jdomWriter.attribute("kind", "lookup");
                this.jdomWriter.attribute("key", lookupValueKey.getKey());
                this.jdomWriter.attribute("provider", lookupValueKey.getProviderId());
            }
            this.jdomWriter.endElement();
        }
        this.jdomWriter.endElement();
    }

    public String toString() {
        return this.jdomWriter.toString();
    }
}

