/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;

import static com.xebialabs.xltype.serialization.json.Converters.checkArgument;

public class SelectedDeploymentJsonConverter {

    public static final String DEPLOYABLE_IDS = "mapping-for-deployables";
    public static final String DEPLOYMENT = "deployment";
    private DeploymentJsonConverter deploymentJsonConverter;

    public SelectedDeploymentJsonConverter(final DeploymentJsonConverter deploymentJsonConverter) {
        this.deploymentJsonConverter = deploymentJsonConverter;
    }

    public String toJson(SelectedDeployment selectedDeployment) {
        JsonWriter writer = new JsonWriter();
        toJson(selectedDeployment, writer);
        return writer.toString();
    }

    public void toJson(final SelectedDeployment selectedDeployment, final JsonWriter writer) {
        writer.object();
        writeSelectedDeployeds(selectedDeployment, writer);
        writeDeployment(selectedDeployment, writer);
        writer.endObject();
    }

    private void writeSelectedDeployeds(final SelectedDeployment deployment, final JsonWriter writer) {
        if (!deployment.getSelectedDeployableIds().isEmpty()) {
            writer.key(DEPLOYABLE_IDS);
            writer.array();
            for (String id : deployment.getSelectedDeployableIds()) {
                writer.value(id);
            }
            writer.endArray();
        }
    }

    private void writeDeployment(final SelectedDeployment selectedDeployment, final JsonWriter writer) {
        writer.key(DEPLOYMENT);
        deploymentJsonConverter.toJson(selectedDeployment.getDeployment(), writer);
    }


    public SelectedDeployment toSelectedDeployment(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            checkArgument(json.has(DEPLOYABLE_IDS), "Missing '%s' property in JSON:\n%s", DEPLOYABLE_IDS, jsonString);
            checkArgument(json.has(DEPLOYMENT), "Missing '%s' property in JSON:\n%s", DEPLOYMENT, jsonString);
            List<String> selectedDeployables = readSelectedDeployables(json);
            Deployment deployment = deploymentJsonConverter.toDeployment(json.getJSONObject(DEPLOYMENT));
            return new SelectedDeployment(selectedDeployables, deployment);
        } catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    public List<String> readSelectedDeployables(final JSONObject json) throws JSONException {
        ArrayList<String> selectedDeployablesIds = new ArrayList<>();
        final JSONArray selectedDeployables = json.getJSONArray(DEPLOYABLE_IDS);
        for (int i = 0; i < selectedDeployables.length(); i++) {
            selectedDeployablesIds.add(selectedDeployables.getString(i));
        }
        return selectedDeployablesIds;
    }
}
