/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.xltype.serialization.CiWriter;

@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
public class ConfigurationItemIdWriter implements MessageBodyWriter<ConfigurationItemId> {

    protected FormatFactory formats = new FormatFactory();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ConfigurationItemId.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(ConfigurationItemId t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(ConfigurationItemId ci, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
        OutputStream entityStream) throws IOException, WebApplicationException {

        CiWriter writer = formats.createCiWriter(mediaType);
        writer.typedCiReference(ci);

        entityStream.write(writer.toString().getBytes());
    }


}
