package com.xebialabs.deployit.engine.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.StepState;

import static com.xebialabs.deployit.engine.xml.Converters.writeNode;

public abstract class AbstractStepConverter implements Converter {
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        StepState s = (StepState) source;
        writer.addAttribute("failures", Integer.toString(s.getFailureCount()));
        writer.addAttribute("state", s.getState().name());

        writeNode("description", s.getDescription(), writer);
        if (s.getStartDate() != null) {
            writeNode("startDate", new DateTimeAdapter().marshal(s.getStartDate()), writer);
        }
        if (s.getCompletionDate() != null) {
            writeNode("completionDate", new DateTimeAdapter().marshal(s.getCompletionDate()), writer);
        }
        if (s.getLog() != null) {
            writeNode("log", s.getLog(), writer);
        }
    }

    @Override
    public boolean canConvert(Class type) {
        return StepState.class.isAssignableFrom(type);
    }
}
