package com.xebialabs.deployit.engine.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.deployit.engine.xml.Converters.writeConfigurationItem;

@XStreamProvider(readable = Control.class, tagName = "control")
public class ControlConverter implements Converter {
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Control c = (Control) source;
        writer.addAttribute("method", c.getControlName());
        writer.startNode("controllable");
        writeConfigurationItem(c.getConfigurationItem(), writer, context);
        writer.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String controlName = reader.getAttribute("method");
        ConfigurationItem ci = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("controllable".equals(reader.getNodeName())) {
                reader.moveDown();
                ci = (ConfigurationItem) context.convertAnother(null, ConfigurationItem.class);
            }
            reader.moveUp();
        }
        return new Control(ci, controlName);
    }

    @Override
    public boolean canConvert(Class type) {
        return Control.class.isAssignableFrom(type);
    }
}
