package com.xebialabs.xltype.serialization.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.ws.rs.core.MediaType;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.StaxDriver;

import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.xstream.CiXStreamWriter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;

public class FormatFactory {

    private static final StaxDriver STAX_DRIVER = new StaxDriver();

    public CiReader createCiReader(InputStream entityStream, MediaType mediaType) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return CiJsonReader.create(toString(entityStream));
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            try {
                HierarchicalStreamReader reader = STAX_DRIVER.createReader(entityStream);
                return new CiXstreamReader(reader);
            } catch (StreamException e) {
                throw new IllegalArgumentException("Can't read content as XML", e);
            }
        } else {
            throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
        }
    }

    public CiListReader createCiListReader(InputStream entityStream, MediaType mediaType) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return CiListJsonReader.create(toString(entityStream));
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            try {
                HierarchicalStreamReader reader = STAX_DRIVER.createReader(entityStream);
                return new CiXstreamReader(reader);
            } catch (StreamException e) {
                throw new IllegalArgumentException("Can't read content as XML", e);
            }
        } else {
            throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
        }
    }

    public CiWriter createCiWriter(MediaType mediaType) {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return new CiJsonWriter();
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return new CiXStreamWriter();
        } else {
            throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
        }
    }

    private static String toString(InputStream in) throws IOException {
        return CharStreams.toString(new InputStreamReader(in, Charsets.UTF_8));
    }
}
