package com.xebialabs.xltype.serialization.json;

import java.io.Writer;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

import com.xebialabs.xltype.serialization.SerializationException;

/**
 * Wraps Jettison's {@link JSONWriter}, but does not throw checked exceptions. All {@link JSONException JSONExceptions}
 * are wrapped by a link {@link SerializationException SerializationExceptions}.
 */
public class JsonWriter {

    private final JSONWriter delegate;

    public JsonWriter(Writer writer) {
        delegate = new JSONWriter(writer);
    }

    public JsonWriter array() {
        try {
            delegate.array();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter endArray() {
        try {
            delegate.endArray();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter endObject() {
        try {
            delegate.endObject();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter key(String s) {
        try {
            delegate.key(s);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter object() {
        try {
            delegate.object();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(boolean b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(double b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(long b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(Object b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }


}
