/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization;

import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.util.ReferenceUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;

public class ConfigurationItemConverter {
    private boolean readValidationMessages = false;
    private boolean writeValidationMessages = false;
    private final List<CiReference> references = new ArrayList<CiReference>();
    private final Map<String, ConfigurationItem> readCIs = new LinkedHashMap<String, ConfigurationItem>();

    public void setReadValidationMessages(boolean enabled) {
        this.readValidationMessages = enabled;
    }

    public void setWriteValidationMessages(boolean enabled) {
        this.writeValidationMessages = enabled;
    }

    public List<CiReference> getReferences() {
        return this.references;
    }

    public Map<String, ConfigurationItem> getReadCIs() {
        return this.readCIs;
    }

    public void writeCis(Collection<ConfigurationItem> cis, CiWriter writer) {
        this.writeCis(cis, writer, 0);
    }

    public void writeCis(Collection<ConfigurationItem> cis, CiWriter writer, int ciRefsFromLevel) {
        writer.startList();
        for (ConfigurationItem ci : cis) {
            this.writeCi(ci, writer, ciRefsFromLevel);
        }
        writer.endList();
    }

    public void writeCi(ConfigurationItem ci, CiWriter writer) {
        this.writeCi(ci, writer, 0);
    }

    public void writeCi(ConfigurationItem ci, CiWriter writer, int ciRefsFromLevel) {
        ci = this.unwrapValidated(ci);
        writer.startCi(ci.getType().toString(), ci.getId());
        if (ci instanceof BaseConfigurationItem) {
            String token = ((BaseConfigurationItem)ci).get$token();
            if (token != null && !token.trim().isEmpty()) {
                writer.token(token);
            }
            writer.ciAttributes(((BaseConfigurationItem)ci).get$ciAttributes());
        }
        this.writeValidationMessages(ci, writer);
        this.writeProperties(ci, writer, ciRefsFromLevel);
        this.writeLookupValues(ci, writer);
        writer.endCi();
    }

    private ConfigurationItem unwrapValidated(ConfigurationItem ci) {
        if (ci instanceof ValidatedConfigurationItem) {
            return ((ValidatedConfigurationItem)ci).getWrapped();
        }
        return ci;
    }

    protected void writeProperties(ConfigurationItem ci, CiWriter writer, int ciRefsFromLevel) {
        for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (propertyDescriptor.isHidden()) continue;
            this.writeProperty(ci, propertyDescriptor, writer, ciRefsFromLevel);
        }
    }

    protected void writeProperty(ConfigurationItem ci, PropertyDescriptor property, CiWriter writer, int ciRefsFromLevel) {
        Object value = property.get(ci);
        if (value == null) {
            return;
        }
        writer.startProperty(property.getName());
        switch (property.getKind()) {
            case STRING: {
                this.writeStringProperty(value, property, writer);
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: {
                writer.valueAsString(value);
                break;
            }
            case DATE: {
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime((Date)value);
                writer.valueAsString(DatatypeConverter.printDateTime((Calendar)cal));
                break;
            }
            case CI: {
                if (property.isNested() || ciRefsFromLevel >= 1 && ConfigurationItemConverter.isContainedChild(value, ci)) {
                    this.writeCi((ConfigurationItem)value, writer, ciRefsFromLevel - 1);
                    break;
                }
                this.writeCiProperty(value, property, writer);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                this.writeCollectionOfStringProperty(value, property, writer);
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                if (ciRefsFromLevel >= 1 && property.isAsContainment()) {
                    Collection collection = (Collection)value;
                    this.writeCis(collection, writer, ciRefsFromLevel - 1);
                    break;
                }
                this.writeCollectionOfCiProperty(value, property, writer);
                break;
            }
            case MAP_STRING_STRING: {
                this.writeMapStringStringProperty(value, property, writer);
            }
        }
        writer.endProperty();
    }

    private static boolean isContainedChild(Object object, ConfigurationItem parent) {
        if (object instanceof ConfigurationItem) {
            ConfigurationItem ci = (ConfigurationItem)object;
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                if (property.getKind() != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        writer.valueAsString(value);
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        writer.mapAsStrings((Map)value);
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        writer.valuesAsStrings((Collection)value);
    }

    protected void writeCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        writer.ciReference(ConfigurationItemConverter.getIdOfCi(value));
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        Collection cis = (Collection)value;
        ArrayList<String> ids = new ArrayList<String>(cis.size());
        for (Object ci : cis) {
            ids.add(ConfigurationItemConverter.getIdOfCi(ci));
        }
        writer.ciReferences(ids);
    }

    protected void writeValidationMessages(ConfigurationItem ci, CiWriter writer) {
        if (!this.writeValidationMessages || ci.get$validationMessages().isEmpty()) {
            return;
        }
        writer.validationMessages(ci.get$validationMessages());
    }

    private void writeLookupValues(ConfigurationItem ci, CiWriter writer) {
        BaseConfigurationItem bci;
        Map externalProperties;
        if (ci instanceof BaseConfigurationItem && !(externalProperties = (bci = (BaseConfigurationItem)ci).get$externalProperties()).isEmpty()) {
            writer.externalProperties(externalProperties);
        }
    }

    public ConfigurationItem readCi(CiReader reader) {
        Type type = this.type(reader.getType());
        String id = reader.getId();
        Descriptor descriptor = type.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("Encountered unknown CI type [" + type + "] for ConfigurationItem [" + id + "]");
        }
        ConfigurationItem ci = descriptor.newInstance(id);
        if (ci instanceof BaseConfigurationItem) {
            BaseConfigurationItem baseConfigurationItem = (BaseConfigurationItem)ci;
            baseConfigurationItem.set$token(reader.getToken());
            baseConfigurationItem.set$ciAttributes(reader.getCiAttributes());
        }
        ci = this.readProperties(reader, descriptor, ci);
        this.readCIs.put(ci.getId(), ci);
        return ci;
    }

    public Type type(String typeName) {
        return Type.valueOf((String)typeName);
    }

    public List<ConfigurationItem> readCis(CiListReader reader) {
        ArrayList<ConfigurationItem> cis = new ArrayList<ConfigurationItem>();
        while (reader.hasMoreChildren()) {
            reader.moveIntoChild();
            ConfigurationItem ci = this.readCi(reader.getCurrentCiReader());
            cis.add(ci);
            reader.moveOutOfChild();
        }
        return cis;
    }

    protected List<Object> readCisOrReferences(CiListReader reader) {
        ArrayList<Object> cis = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveIntoChild();
            CiReader currentCiReader = reader.getCurrentCiReader();
            if (currentCiReader.isCiReference()) {
                cis.add(currentCiReader.getCiReference());
            } else {
                ConfigurationItem ci = this.readCi(currentCiReader);
                cis.add(ci);
            }
            reader.moveOutOfChild();
        }
        return cis;
    }

    protected ConfigurationItem readProperties(CiReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        ConfigurationItem toBeReturned = configurationItem;
        while (reader.hasMoreProperties()) {
            reader.moveIntoProperty();
            if (reader.getCurrentPropertyName().equals("validation-messages")) {
                if (this.readValidationMessages) {
                    List<ValidationMessage> validationMessages = reader.getValidationMessages();
                    if (configurationItem instanceof BaseConfigurationItem) {
                        configurationItem.get$validationMessages().addAll(validationMessages);
                    }
                    ValidatedConfigurationItem validatedCi = new ValidatedConfigurationItem(configurationItem);
                    validatedCi.setValidations(validationMessages);
                    toBeReturned = validatedCi;
                }
            } else if (reader.getCurrentPropertyName().equals("external-properties")) {
                if (configurationItem instanceof BaseConfigurationItem) {
                    BaseConfigurationItem bci = (BaseConfigurationItem)configurationItem;
                    Map<String, ExternalProperty> externalProperties = reader.getExternalProperties();
                    if (!externalProperties.isEmpty()) {
                        bci.set$externalProperties(externalProperties);
                    }
                }
            } else {
                this.readProperty(reader, descriptor, configurationItem);
            }
            reader.moveOutOfProperty();
        }
        return toBeReturned;
    }

    protected void readProperty(CiReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        String propName = reader.getCurrentPropertyName();
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(propName);
        if (propertyDescriptor == null) {
            throw new IllegalStateException("Encountered unknown ConfigurationItem property [" + descriptor.getType() + "." + propName + "] for ci [" + configurationItem.getId() + "]");
        }
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                this.readStringProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case BOOLEAN: 
            case INTEGER: {
                propertyDescriptor.set(configurationItem, (Object)reader.getStringValue());
                break;
            }
            case ENUM: {
                propertyDescriptor.set(configurationItem, this.nonEmpty(reader.getStringValue()).orElse(null));
                break;
            }
            case DATE: {
                String stringValue = reader.getStringValue();
                if (stringValue == null || stringValue.trim().isEmpty()) break;
                propertyDescriptor.set(configurationItem, (Object)DatatypeConverter.parseDateTime((String)stringValue).getTime());
                break;
            }
            case CI: {
                this.readCiProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                this.readCollectionOfStringProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                this.readCollectionOfCiProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case MAP_STRING_STRING: {
                this.readMapStringStringProperty(configurationItem, propertyDescriptor, reader);
            }
        }
    }

    private Optional<String> nonEmpty(String stringValue) {
        return stringValue != null && !stringValue.trim().isEmpty() ? Optional.of(stringValue) : Optional.empty();
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        String value = reader.getStringValue();
        if (value != null) {
            String trimmedValue = value.trim();
            propertyDescriptor.set(configurationItem, (Object)(!trimmedValue.equals("") ? trimmedValue : value));
        } else {
            propertyDescriptor.set(configurationItem, (Object)value);
        }
    }

    protected void readMapStringStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        Map<String, String> map = reader.getStringMap();
        propertyDescriptor.set(configurationItem, map);
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        SequencedCollection<String> strings = reader.getStringValues();
        if (propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING) {
            strings = new LinkedHashSet<String>(strings);
        }
        propertyDescriptor.set(configurationItem, strings);
    }

    protected static String getIdOfCi(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ConfigurationItem) {
            return ((ConfigurationItem)object).getId();
        }
        throw new IllegalArgumentException(String.format("Value should be of type String or Configuration Item, but is %s (%s)", object.getClass().getName(), object));
    }

    protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (reader.isCiReference()) {
            String id = reader.getCiReference();
            if (StringUtils.isNotBlank((String)id)) {
                this.references.add(new CiReference(configurationItem, propertyDescriptor, id));
            }
        } else {
            ConfigurationItem child = this.readCi(reader.moveIntoNestedProperty());
            propertyDescriptor.set(configurationItem, (Object)child);
            reader.moveOutOfProperty();
        }
    }

    protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        List<Object> items = this.readCisOrReferences(reader.getCurrentCiListReader());
        if (items.isEmpty()) {
            return;
        }
        if (items.get(0) instanceof String) {
            List<Object> strings = items;
            this.references.add(new CiReference(configurationItem, propertyDescriptor, strings));
        } else if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI) {
            propertyDescriptor.set(configurationItem, new LinkedHashSet<Object>(items));
        } else {
            propertyDescriptor.set(configurationItem, items);
        }
    }

    public void resolveReferences(Repository repository, Boolean skipNotExistingCis) {
        ReferenceUtils.resolveReferences(this.getReferences(), this.getReadCIs(), repository, skipNotExistingCis);
    }

    public void resolveReferences(Repository repository) {
        this.resolveReferences(repository, false);
    }
}

