/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String FALLBACK = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String[] rfc822DateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm z", "dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yyyy HH:mm z", "dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE, dd MMM yyyy z"};

    public static String toString(DateTime v) {
        return DateTimeFormat.forPattern((String)FALLBACK).print((ReadableInstant)v);
    }

    private static DateTime parseISO8601(String v) {
        try {
            return ISODateTimeFormat.dateTime().withZoneUTC().parseDateTime(v);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DateTime fromString(String v) {
        DateTime dateTime = DateUtil.parseISO8601(v);
        if (dateTime != null) {
            return dateTime;
        }
        for (String rfc822DateFormat : rfc822DateFormats) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(rfc822DateFormat, Locale.ENGLISH);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date parse = simpleDateFormat.parse(v);
                Calendar cal = Calendar.getInstance(Locale.ENGLISH);
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                cal.setTime(parse);
                dateTime = new DateTime((Object)cal);
                break;
            }
            catch (ParseException ignore) {
                logger.trace(String.format("Failed to parse [%s] using [%s]", v, rfc822DateFormat), (Throwable)ignore);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException(String.format("Could not parse date [%s] using ISO8601 or RFC822 pattern.", v));
        }
        return dateTime;
    }
}

