package com.xebialabs.json_patch

import com.fasterxml.jackson.core.JsonFactory
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator.Feature.USE_PLATFORM_LINE_BREAKS
import com.fasterxml.jackson.dataformat.yaml.{YAMLFactory, YAMLMapper}

trait JsonSupport {

  protected val jsonFactory: JsonFactory = new JsonFactory()
  protected val yamlFactory: YAMLFactory = new YAMLFactory()
  protected val jsonMapper: ObjectMapper = new ObjectMapper()
  protected val yamlMapper: ObjectMapper = new YAMLMapper(yamlFactory).enable(USE_PLATFORM_LINE_BREAKS)

}
