package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.google.common.collect.Sets.newHashSet;

class LocalPropertyDescriptorWithDifferentOwner extends LocalPropertyDescriptor {

    private final LocalPropertyDescriptor superPropertyDescriptor;

    public LocalPropertyDescriptorWithDifferentOwner(LocalPropertyDescriptor pd, LocalDescriptor newOwner) {
        this.superPropertyDescriptor = pd;
        this.setDeclaringDescriptor(newOwner);
        setFromPropertyDescriptor(pd);
        registerDefault(pd);
    }

    @Override
    public Object get(ConfigurationItem item) {
        return superPropertyDescriptor.get(item);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        superPropertyDescriptor.set(item, value);
    }
}
