package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import org.w3c.dom.Element;


class SyntheticLocalDescriptor extends LocalDescriptor {

    private GeneratedDeployableDescription generatedDeployableDescription;
    private SyntheticParser parser = SyntheticParser.PARSER;

    public SyntheticLocalDescriptor(Element element) {
        Type type = parser.parseType(element);
        setType(type);
        initSynthetic(element);
        initHierarchy();
    }

    private void initSynthetic(Element element) {
        Type superType = parser.parseSuperType(element);
        addSuperClass(superType);
        setLabel(parser.parseLabel(element).orElse(toLabel(getType())));
        setDescription(parser.parseDescription(element).orElse("Description unavailable"));
        setVirtual(parser.parseVirtual(element).orElse(false));
        setVersioned(parser.parseVersioned(element).orElse(superType.getDescriptor().isVersioned()));
        setInspectable(parser.parseInspectable(element).orElse(false));
        setIcon(parser.parseIcon(element).orElse(superType.getDescriptor().getIcon()));
        setRootName(parser.parseRoot(element));
        parser.parseConteinerType(element).ifPresent(this::setContainerType);
        parser.parseDeployedType(element).ifPresent(this::setDeployableType);
        validators.addAll(parser.parseValidators(element, getType()));
        verifications.addAll(parser.parseVerifications(element, getType()));
        parser.parseControlTasks(this, element).forEach(this::validateAndAddControlTask);
        parser.parseProperties(this, element).forEach(this::overrideOrAddPropertyDescriptor);
        generatedDeployableDescription = parser.parseGeneratedDeployableDescription(element);
    }

    public GeneratedDeployableDescription getGeneratedDeployableDescription() {
        return generatedDeployableDescription;
    }
}
