package com.xebialabs.xlplatform.synthetic.xml;

import java.util.*;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

import static com.xebialabs.deployit.booter.local.utils.Strings.split;

public class XmlPropertySpecification extends XmlElement implements PropertySpecification {

    public XmlPropertySpecification(Element element) {
        super(element);
    }

    @Override
    public String getName() {
        return XmlUtils.getRequiredStringAttribute(element, "name");
    }

    @Override
    public Optional<String> getKind() {
        return XmlUtils.getOptionalString(element, "kind");
    }

    @Override
    public Optional<String> getCategory() {
        return XmlUtils.getOptionalString(element, "category");
    }

    @Override
    public Optional<String> getLabel() {
        return XmlUtils.getOptionalString(element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return XmlUtils.getOptionalString(element, "description");
    }

    @Override
    public Optional<Boolean> getRequired() {
        return XmlUtils.getOptionalBoolean(element, "required");
    }

    @Override
    public Optional<Boolean> getPassword() {
        return XmlUtils.getOptionalBoolean(element, "password");
    }

    @Override
    public Optional<Boolean> getAsContainment() {
        return XmlUtils.getOptionalBoolean(element, "as-containment");
    }

    @Override
    public Optional<Boolean> getNested() {
        return XmlUtils.getOptionalBoolean(element, "nested");
    }

    @Override
    public Optional<String> getSize() {
        return XmlUtils.getOptionalString(element, "size");
    }

    @Override
    public Optional<String> getDefault() {
        return XmlUtils.getOptionalString(element, "default");
    }

    @Override
    public Optional<Boolean> getHidden() {
        return XmlUtils.getOptionalBoolean(element, "hidden");
    }

    @Override
    public Optional<Boolean> getInspectionProperty() {
        return XmlUtils.getOptionalBoolean(element, "inspectionProperty");
    }

    @Override
    public Set<String> getAliases() {
        return new LinkedHashSet<>(split(XmlUtils.getOptionalStringAttribute(element, "aliases", ""), ","));
    }

    @Override
    public Optional<Boolean> getTransient() {
        return XmlUtils.getOptionalBoolean(element, "transient");
    }

    @Override
    public Optional<String> getCandidateValuesFilter() {
        return XmlUtils.getOptionalString(element, "candidate-values-filter");
    }

    @Override
    public Optional<Boolean> getReadOnly() {
        return XmlUtils.getOptionalBoolean(element, "readonly");
    }

    @Override
    public Optional<String> getEnumClass() {
        return XmlUtils.getOptionalString(element, "enum-class");
    }

    @Override
    public List<String> getEnumValues() {
        List<String> enumValues = new ArrayList<>();
        final NodeList values = element.getElementsByTagName("enum-values");
        if (values.getLength() == 1) {
            XmlUtils.forEach(XmlUtils.childByName((Element) values.item(0), "value"::equals), element -> enumValues.add(element.getTextContent()));
        }
        return enumValues;
    }

    @Override
    public Optional<String> getReferencedType() {
        return XmlUtils.getOptionalString(element, "referenced-type");
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        List<ValidationRuleSpecification> rules = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "rule"::equals), e ->
                rules.add(new XmlValidationRuleSpecification(e)));
        return rules;
    }

    @Override
    public List<InputHintSpecification> getInputHints() {
        List<InputHintSpecification> rules = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "input-hint"::equals), e ->
                rules.add(new XmlInputHintSpecification(e)));
        return rules;
    }
}
