package com.xebialabs.xlplatform.synthetic.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.TypeName;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

import static com.xebialabs.deployit.plugin.api.reflect.InputHintValue.inputHintValue;

public class XmlInputHintSpecification extends XmlElement implements InputHintSpecification {

    public XmlInputHintSpecification(Element element) {
        super(element);
    }

    @Override
    public List<InputHintValue> getValues() {
        List<InputHintValue> inputHintValues = new ArrayList<>();
        forEach(childByName(element, "values"::equals), valuesElement ->
                forEach(childByName(valuesElement, "value"::equals), valueElement -> {
                    String value = valueElement.getTextContent();
                    String label = getOptionalStringAttribute(valueElement, "label", value);
                    inputHintValues.add(inputHintValue(value, label));
                })
        );
        return inputHintValues;
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        return new XmlPropertySpecification(element).getValidationRules();
    }

    @Override
    public Optional<String> getPrompt() {
        return getOptionalTextOfChild(element, "prompt");
    }

    @Override
    public Optional<String> getCopyFromProperty() {
        return getOptionalTextOfChild(element, "copy-from-property");
    }

    @Override
    public Optional<TypeName> getReferencedType() {
        return Optional.ofNullable(getOptionalTypeAttribute(element, "referenced-type"));
    }

    @Override
    public Optional<String> getMethodRef() {
        return getOptionalString(element, "method-ref");
    }

    @Override
    public Optional<Boolean> getDynamicLookup() {
        return getOptionalBoolean(element, "dynamic-lookup");
    }
}
