/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.packager.writers;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.jdom.CiJdomWriter;
import com.xebialabs.xltype.serialization.jdom.JdomWriter;

public class ManifestXmlWriter implements ManifestWriter {

    private JdomWriter writer = new JdomWriter();

    @Override
    public String getManifestFileName() {
        return "deployit-manifest.xml";
    }

    @Override
    public ManifestCiWriter writeVersion(Type type, String version, String application) {
        writer.element(type.toString())
                .attribute("version", version)
                .attribute("application", application);
        return new ManifestXmlCiWriter(writer);
    }

    @Override
    public void endManifest() {
        writer.endElement();
    }

    @Override
    public ManifestCiWriter writeCi(String name, Type type) {
        writer.element(type.toString()).attribute("name", name);
        return new ManifestXmlCiWriter(writer);
    }

    @Override
    public ManifestCiWriter writeCi(String name, Type type, String fileArtifact) {
        writer.element(type.toString()).attribute("name", name);
        writer.attribute("file", fileArtifact);
        return new ManifestXmlCiWriter(writer);
    }

    class ManifestXmlCiWriter implements ManifestCiWriter {
        CiJdomWriter writer;

        ManifestXmlCiWriter(JdomWriter jdomWriter) {
            writer = new CiJdomWriter(jdomWriter);
        }

        @Override
        public void property(String propertyName) {
            writer.startProperty(propertyName);
        }

        @Override
        public void writeAsStringValue(String value) {
            writer.valueAsString(value);
        }

        @Override
        public void writeCiReferenceProperty(String ref) {
            writer.ciReference(ref);
        }

        @Override
        public void writeStringCollectionProperty(List<String> values) {
            writer.valuesAsStrings(values);
        }

        @Override
        public void writeCiReferenceCollectionProperty(List<String> values) {
            writer.ciReferences(values);
        }

        @Override
        public void writeMapStringStringProperty(Map<String, String> values) {
            writer.mapAsStrings(values);
        }

        @Override
        public void endProperty() {
            writer.endProperty();
        }

        @Override
        public ManifestWriter endCi() {
            ManifestXmlWriter.this.writer.endElement();
            return ManifestXmlWriter.this;
        }
    }

    @Override
    public String toString() {
        return writer.toString();
    }
}
