package com.xebialabs.deployit.engine.packager.content;

import java.io.IOException;
import com.google.common.io.Closeables;

import com.xebialabs.deployit.engine.packager.manifest.ManifestWriter;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;

/**
 * All ancestors should be able to hold some content and implement a method which writes this content into a dar file.
 */
public abstract class DarContents {

    public abstract void fillIn(TFile file) throws IOException;

    public abstract String getPackageName();

    public void attachManifest(TFile dar, ManifestWriter manifestWriter) {
        TFileOutputStream out = null;
        try {
            TFile manifestFile = new TFile(dar, "/META-INF/MANIFEST.MF");
            out = new TFileOutputStream(manifestFile);
            manifestWriter.writeTo(out);
        } catch (Exception e) {
            throw new RuntimeException("Errors found while adding manifest file to dar", e);
        } finally {
            Closeables.closeQuietly(out);
        }
    }

}
