package com.xebialabs.deployit.engine.tasker;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;

import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.convert.DecorateAsJava;
import scala.collection.convert.Decorators;
import scala.collection.immutable.List;

import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

public class OldExecutionContextListenerCleanupTrigger implements ExecutionStateListener {
    @Override
    public void stepStateChanged(final StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(final TaskExecutionStateEvent event) {
        if (checkTransition(event, TaskExecutionState2.EXECUTING, TaskExecutionState2.EXECUTED) || checkTransition(event, TaskExecutionState2.EXECUTING, TaskExecutionState2.STOPPED)) {
            NestedTaskExecutionContext context = ((Task) event.task()).getContext();
            cleanContext(context);
        }
    }

    private void cleanContext(final NestedTaskExecutionContext context) {
        // You really gotte love implicits in Scala to perform these conversions
        Map<String, Object> stringObjectMap = JavaConversions.asJavaMap(context.attributes());
        for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
            if (entry.getValue() instanceof ExecutionContextListener) {
                logger.info("Cleaning up [{}] which is an [{}]", entry.getKey(), entry.getValue());
                cleanupListener((ExecutionContextListener) entry.getValue());

            }
        }
    }

    private void cleanupListener(final ExecutionContextListener listener) {
        try {
            listener.contextDestroyed();
        } catch (RuntimeException re) {
            logger.error("Exception while cleaning up object {} in execution context", listener);
            logger.error("Exception is: ", re);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(OldExecutionContextListenerCleanupTrigger.class);
}
