package com.xebialabs.deployit.engine

import akka.actor.{ActorContext, ActorRef, Props}

package object tasker {
  type Cache[A, B] = collection.mutable.Map[A, B]
  val Cache = collection.mutable.Map

  type TaskId = String
  type BlockId = String
  type StepId = String

  trait ActorCreationSupport {
    def createChild(props: Props, name: String): ActorRef
  }

  trait ActorContextCreationSupport extends ActorCreationSupport {
    def context: ActorContext
    def createChild(props: Props, name: String): ActorRef = context.actorOf(props, name)
  }
}
