/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.engine.tasker.NestedTaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;

public class OldExecutionContextListenerCleanupTrigger
implements ExecutionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(OldExecutionContextListenerCleanupTrigger.class);

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.EXECUTING, (TaskExecutionState2)TaskExecutionState2.EXECUTED) || Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.EXECUTING, (TaskExecutionState2)TaskExecutionState2.STOPPED)) {
            NestedTaskExecutionContext context = ((Task)event.task()).getContext();
            this.cleanContext(context);
        }
    }

    private void cleanContext(NestedTaskExecutionContext context) {
        Map stringObjectMap = JavaConversions.asJavaMap(context.attributes());
        for (Map.Entry entry : stringObjectMap.entrySet()) {
            if (!(entry.getValue() instanceof ExecutionContextListener)) continue;
            logger.info("Cleaning up [{}] which is an [{}]", entry.getKey(), entry.getValue());
            this.cleanupListener((ExecutionContextListener)entry.getValue());
        }
    }

    private void cleanupListener(ExecutionContextListener listener) {
        try {
            listener.contextDestroyed();
        }
        catch (RuntimeException re) {
            logger.error("Exception while cleaning up object {} in execution context", (Object)listener);
            logger.error("Exception is: ", (Throwable)re);
        }
    }
}

