/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import nl.javadude.scannit.Scannit;

public class JavaBasedRuleBuilder {
    void findDeployedRules() {
        this.registerDeployedContributors(Create.class, Operation.CREATE);
        this.registerDeployedContributors(Modify.class, Operation.MODIFY);
        this.registerDeployedContributors(Destroy.class, Operation.DESTROY);
        this.registerDeployedContributors(Noop.class, Operation.NOOP);
    }

    void findContributors() {
        TreeSet<Method> contributors = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        contributors.addAll(this.checkContributors(Scannit.getInstance().getMethodsAnnotatedWith(Contributor.class)));
        for (Method method : contributors) {
        }
    }

    private void registerDeployedContributors(Class<? extends Annotation> annotation, Operation operation) {
        TreeSet<Method> typeContributors = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        typeContributors.addAll(this.checkDeployedContributors(Scannit.getInstance().getMethodsAnnotatedWith(annotation)));
        for (Method typeContributor : typeContributors) {
            Type t = Type.valueOf(typeContributor.getDeclaringClass());
        }
    }

    private Set<Method> checkDeployedContributors(Set<Method> deployedContributors) {
        for (Method c : deployedContributors) {
            Preconditions.checkArgument((boolean)c.getReturnType().equals(Void.TYPE), (String)"DeployedContributor %s should have void return type.", (Object[])new Object[]{c});
            Class<?>[] parameterTypes = c.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length <= 2 && parameterTypes.length >= 1 ? 1 : 0) != 0, (String)"DeployedContributor %s should take 1 or 2 parameters.", (Object[])new Object[]{c});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(DeploymentPlanningContext.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, DeploymentPlanningContext.class});
            if (parameterTypes.length != 2) continue;
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(Delta.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, Delta.class});
        }
        return deployedContributors;
    }

    private Set<Method> checkContributors(Set<Method> contributors) {
        for (Method contributor : contributors) {
            Preconditions.checkArgument((boolean)contributor.getReturnType().equals(Void.TYPE), (String)"Contributor %s should have void return type.", (Object[])new Object[]{contributor});
            Class<?>[] parameterTypes = contributor.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 2 ? 1 : 0) != 0, (String)"Contributor %s should take 2 parameters.", (Object[])new Object[]{contributor});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(Deltas.class), (String)"Contributor %s should take %s as first parameter.", (Object[])new Object[]{contributor, Deltas.class});
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(DeploymentPlanningContext.class), (String)"Contributor %s should take %s as second parameter.", (Object[])new Object[]{contributor, DeploymentPlanningContext.class});
        }
        return contributors;
    }

    public static class HierarchyClassMethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method method, Method method1) {
            String name2;
            Class<?> class2;
            Class<?> class1 = method.getDeclaringClass();
            if (this.isSuperClass(class1, class2 = method1.getDeclaringClass())) {
                return -1;
            }
            if (this.isSuperClass(class2, class1)) {
                return 1;
            }
            String name1 = class1.getName();
            int nameComparison = name1.compareTo(name2 = class2.getName());
            if (nameComparison == 0) {
                return method.getName().compareTo(method1.getName());
            }
            return nameComparison;
        }

        boolean isSuperClass(Class<?> c1, Class<?> c2) {
            return c1.isAssignableFrom(c2) && !c1.getName().equals(c2.getName());
        }
    }
}

