package com.xebialabs.deployit.deployment.rules;

public enum Scope {
    DEPLOYED("deployed"),
    PLAN("plan"),
    PRE_PLAN("pre-plan"),
    POST_PLAN("post-plan");

    private String scopeName;

    private Scope(String scopeName) {
        this.scopeName = scopeName;
    }

    public String getScopeName() {
        return scopeName;
    }

    @Override
    public String toString() {
        return scopeName;
    }

    public static Scope getScope(String scopeName) {
        for (Scope scope : Scope.values()) {
            if (scope.getScopeName().equals(scopeName)) {
                return scope;
            }
        }
        throw new IllegalArgumentException(String.format("Could not find scope for name [%s]", scopeName));
    }
}
