package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext
import grizzled.slf4j.Logging

abstract class Rule(name: String, scope: Scope) extends Logging {
  var enabled: Boolean = true
  def getName = name
  def getScope = scope
  def isEnabled = enabled
  def disable() { enabled = false }

  /**
   * Fire this rule for a scoped object. The scopedObject depends on the Scope and is one of the following:
   * <p/>
   * <ul><li>For scope = 'deployed' it is a udm.Deployed</li>
   * <li>For scope = 'plan' it is a Deltas object</li>
   * <li>For scope = 'pre-plan' or scope = 'post-plan' it is a DeltaSpecification object</li></ul>
   *
   * @param scopedObject
   * @param context
   */
  def fire(scopedObject: AnyRef, context: DeploymentPlanningContext): Unit
}

abstract class CanFireRule(name: String, scope: Scope) extends Rule(name, scope) {
  def canFire(scopedObject: AnyRef, context: DeploymentPlanningContext): Boolean

  def doFire(scopedObject: AnyRef, context: DeploymentPlanningContext): Unit

  override final def fire(scopedObject: AnyRef, context: DeploymentPlanningContext): Unit = {
    if (canFire(scopedObject, context)) {
      doFire(scopedObject, context)
    }
  }
}
