/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.deployment.rules.CheckpointParser;
import com.xebialabs.deployit.deployment.rules.CheckpointValidation;
import com.xebialabs.deployit.deployment.rules.ConditionsParser;
import com.xebialabs.deployit.deployment.rules.XmlCheckpoint;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;

public abstract class CheckpointValidation$class {
    public static void ensureCheckpointsAreValidForScopeDeployed(CheckpointValidation $this, Node ruleNode) {
        scala.collection.immutable.Seq<XmlCheckpoint> checkpoints = $this.collectFromSteps(ruleNode, ((CheckpointParser)((Object)$this)).checkpoint());
        if (((ConditionsParser)((Object)$this)).operations(ruleNode).toSet().forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Operation x$7) {
                Operation operation = x$7;
                Operation operation2 = Operation.MODIFY;
                return !(operation != null ? !operation.equals(operation2) : operation2 != null);
            }
        })) {
            CheckpointValidation$class.ensureCheckpointsHaveCorrectOperation($this, checkpoints);
            CheckpointValidation$class.ensureCheckpointsAreNotMoreThan($this, checkpoints, 2);
        } else {
            Predef$.MODULE$.require(checkpoints.forall((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(XmlCheckpoint x$8) {
                    return x$8.overrideOperation().isEmpty();
                }
            }), (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "operation must be MODIFY and no other operation specified to be able to set override-operation on a checkpoint";
                }
            });
            CheckpointValidation$class.ensureCheckpointsAreNotMoreThan($this, checkpoints, 1);
        }
    }

    public static void ensureCheckpointAreValidForScopesPlan(CheckpointValidation $this, Node ruleNode) {
        $this.ensureNotPresent($this.collectFromSteps(ruleNode, ((CheckpointParser)((Object)$this)).checkpoint()), "checkpoint");
    }

    private static void ensureCheckpointsHaveCorrectOperation(CheckpointValidation $this, Iterable checkpoints) {
        Seq validOperations = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Operation.CREATE, Operation.DESTROY, Operation.MODIFY}));
        boolean valid = ((IterableLike)checkpoints.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends XmlCheckpoint, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Option<Operation> o;
                A1 A1 = x3;
                Object object = A1 != null && (o = A1.overrideOperation()).isDefined() ? o.get() : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(XmlCheckpoint x3) {
                Option<Operation> o;
                XmlCheckpoint xmlCheckpoint = x3;
                boolean bl = xmlCheckpoint != null && (o = xmlCheckpoint.overrideOperation()).isDefined();
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this, validOperations){
            public static final long serialVersionUID = 0L;
            private final Seq validOperations$1;

            public final boolean apply(Object elem) {
                return this.validOperations$1.contains(elem);
            }
            {
                this.validOperations$1 = validOperations$1;
            }
        });
        Predef$.MODULE$.require(valid, (Function0)new Serializable($this, validOperations){
            public static final long serialVersionUID = 0L;
            private final Seq validOperations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint can have operation attribute set to ", " or not defined at all"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.validOperations$1.mkString(", ")}));
            }
            {
                this.validOperations$1 = validOperations$1;
            }
        });
    }

    private static void ensureCheckpointsAreNotMoreThan(CheckpointValidation $this, Iterable checkpoints, int maxCount) {
        Predef$.MODULE$.require(checkpoints.size() <= maxCount, (Function0)new Serializable($this, maxCount){
            public static final long serialVersionUID = 0L;
            private final int maxCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only ", " checkpoint(s) are allowed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxCount$1)}));
            }
            {
                this.maxCount$1 = maxCount$1;
            }
        });
    }

    public static void $init$(CheckpointValidation $this) {
    }
}

