/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentPlanningContext
implements DeploymentPlanningContext {
    private static final Function<DeploymentStep, Step> adapt = new Function<DeploymentStep, Step>(){

        public Step apply(DeploymentStep input) {
            return StepAdapter.wrapIfNeeded(input);
        }
    };
    private final HashMap<String, Object> attributes = Maps.newHashMap();
    private DeployedApplication deployedApplication;
    private Repository readOnlyRepository;
    private StepPlan plan;
    private static final Logger logger = LoggerFactory.getLogger(DefaultDeploymentPlanningContext.class);

    public DefaultDeploymentPlanningContext(DeployedApplication deployedApplication, Repository readOnlyRepository, StepPlan plan) {
        this.deployedApplication = deployedApplication;
        this.readOnlyRepository = readOnlyRepository;
        this.plan = plan;
    }

    public void addStep(DeploymentStep step2) {
        this.addStep((Step)adapt.apply((Object)step2));
    }

    public void addSteps(DeploymentStep ... steps) {
        this.addSteps(Iterables.transform((Iterable)Lists.newArrayList((Object[])steps), adapt));
    }

    public void addSteps(Collection<DeploymentStep> steps) {
        this.addSteps(Iterables.transform(steps, adapt));
    }

    public void addStep(Step step2) {
        logger.trace("Adding step [{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        this.plan.addStep(step2);
    }

    public void addSteps(Step ... steps) {
        logger.trace("Adding steps");
        for (Step step2 : steps) {
            logger.trace("[{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        }
        this.plan.addSteps(Lists.newArrayList((Object[])steps));
    }

    public void addSteps(Iterable<Step> steps) {
        logger.trace("Adding steps");
        for (Step step2 : steps) {
            logger.trace("[{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        }
        this.plan.addSteps(Lists.newArrayList(steps));
    }

    public void addCheckpoint(Step step2, Delta delta) {
        this.plan.getCheckpoints().add(new StepPlan.Checkpoint(delta, step2));
    }

    public void addCheckpoint(Step step2, Delta delta, Operation overrideOperation) {
        if (delta.getOperation() != Operation.MODIFY) {
            Preconditions.checkArgument((delta.getOperation() == overrideOperation ? 1 : 0) != 0, (Object)String.format("The delta's operation (%s) and overrideOperation (%s) should match in non-modify scenarios", delta.getOperation(), overrideOperation));
        }
        this.plan.getCheckpoints().add(new StepPlan.Checkpoint(delta, step2, overrideOperation));
    }

    public void addCheckpoint(Step step2, Iterable<Delta> deltas) {
        for (Delta delta : deltas) {
            this.plan.getCheckpoints().add(new StepPlan.Checkpoint(delta, step2));
        }
    }

    public void addStepWithCheckpoint(Step step2, Delta delta) {
        this.addStep(step2);
        this.addCheckpoint(step2, delta);
    }

    public void addStepWithCheckpoint(Step step2, Delta delta, Operation overrideOperation) {
        this.addStep(step2);
        this.addCheckpoint(step2, delta, overrideOperation);
    }

    public void addStepWithCheckpoint(Step step2, Iterable<Delta> deltas) {
        this.addStep(step2);
        this.addCheckpoint(step2, deltas);
    }

    public Object getAttribute(String param) {
        return this.attributes.get(param);
    }

    public void setAttribute(String param, Object value) {
        this.attributes.put(param, value);
        if (value instanceof ExecutionStateListener) {
            this.plan.getListeners().add((ExecutionStateListener)value);
        }
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public Repository getRepository() {
        return this.readOnlyRepository;
    }
}

