package com.xebialabs

import scala.util.matching.Regex
import scala.util.matching.Regex.Match
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta

package object platform {
  
  implicit class DeltaUtils(delta: Delta) {
    def correctDeployed = if (delta.getDeployed != null) delta.getDeployed else delta.getPrevious
  }

  private val camelCaseFinder: Regex = new scala.util.matching.Regex("([a-z0-9]*)([A-Z])", "lowerCase", "upperCase")

  implicit class CaseConverter(value: String) {

    def camelCaseToDashCase: String = camelCaseFinder.replaceAllIn(value, (m: Match) => s"${m.group("lowerCase")}-${m.group("upperCase").toLowerCase}")

    def underscoresToDashes = value.replaceAll("_", "-")
  }
}
