/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteBlockState;
import com.xebialabs.deployit.booter.remote.execution.RemoteCompositeBlockState;
import com.xebialabs.deployit.booter.remote.execution.RemoteStepBlockState;
import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.AbstractBlockConverter;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;

@XStreamProvider(readable=BlockState.class, tagName="block")
public class BlockConverter
extends AbstractBlockConverter {
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteBlockState block;
        if (reader.getAttribute("current") != null) {
            block = new RemoteStepBlockState();
            this.readStepBlockState(reader, context, (RemoteStepBlockState)block);
        } else if (reader.getAttribute("parallel") != null) {
            block = new RemoteCompositeBlockState();
            this.readCompositeBlockState(reader, context, (RemoteCompositeBlockState)block);
        } else {
            block = new RemoteBlockState();
            this.readBlockState(reader, context, block);
        }
        return block;
    }

    private void readBlockState(HierarchicalStreamReader reader, UnmarshallingContext context, RemoteBlockState block) {
        block.setId(reader.getAttribute("id"));
        block.setDescription(reader.getAttribute("description"));
        block.setState(BlockExecutionState.valueOf((String)reader.getAttribute("state")));
    }

    private void readCompositeBlockState(HierarchicalStreamReader reader, UnmarshallingContext context, RemoteCompositeBlockState block) {
        this.readBlockState(reader, context, block);
        block.setParallel(Boolean.parseBoolean(reader.getAttribute("parallel")));
        List blockStates = Converters.readList((Object)block, BlockState.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
        block.setBlocks(blockStates);
    }

    private void readStepBlockState(HierarchicalStreamReader reader, UnmarshallingContext context, RemoteStepBlockState block) {
        this.readBlockState(reader, context, block);
        block.setCurrentStep(Integer.parseInt(reader.getAttribute("current")));
        List stepStates = Converters.readList((Object)block, StepState.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
        block.setSteps(stepStates);
    }
}

