/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

class PropertyConverter {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");

    PropertyConverter() {
    }

    public static Object convertValue(PropertyKind kind, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (kind.equals((Object)PropertyKind.BOOLEAN)) {
                return Boolean.valueOf((String)value);
            }
            if (kind.equals((Object)PropertyKind.INTEGER)) {
                return Integer.valueOf((String)value);
            }
            if (kind.equals((Object)PropertyKind.DATE)) {
                return DatatypeConverter.parseDateTime((String)((String)value)).getTime();
            }
            if (kind.equals((Object)PropertyKind.LIST_OF_STRING)) {
                return PropertyConverter.splitToList((String)value);
            }
            if (kind.equals((Object)PropertyKind.SET_OF_STRING)) {
                return Sets.newHashSet(PropertyConverter.splitToList((String)value));
            }
            if (kind.equals((Object)PropertyKind.MAP_STRING_STRING)) {
                return PropertyConverter.splitToKeyValueMap((String)value);
            }
        }
        return value;
    }

    private static List<String> splitToList(String value) {
        ArrayList r = Lists.newArrayList();
        for (String s : SPLIT_PATTERN.split(value.trim())) {
            if (s.isEmpty()) continue;
            r.add(s);
        }
        return r;
    }

    private static Map<String, String> splitToKeyValueMap(String value) {
        HashMap m = Maps.newHashMap();
        for (String s : SPLIT_PATTERN.split(value.trim())) {
            if (s.isEmpty()) continue;
            int idx = s.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException(String.format("Invalid MAP_STRING_STRING format '%s' entry '%s'", value, s));
            }
            if (m.put(s.substring(0, idx), s.substring(idx + 1)) == null) continue;
            throw new IllegalArgumentException(String.format("Invalid MAP_STRING_STRING '%s' duplicate entry '%s'", value, s));
        }
        return m;
    }
}

