/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitEntityExtractorFactory;
import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private HttpClientHolder httpClientHolder;
    private BooterConfig booterConfig;
    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);

    @Deprecated
    public Proxies(DeployitCommunicator communicator) {
        this.httpClientHolder = communicator.getHttpClientHolder();
        this.booterConfig = communicator.getConfig();
        this.init(communicator.getConfig());
    }

    public Proxies(HttpClientHolder httpClientHolder, BooterConfig config) {
        this.httpClientHolder = httpClientHolder;
        this.booterConfig = config;
        this.init(config);
    }

    private void init(BooterConfig config) {
        for (Class<?> clazz : Proxies.allProxies()) {
            this.registerProxy(config.getUrl(), clazz);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        ClientExecutor clientExecutor = this.httpClientHolder.createClientExecutor();
        HashMap requestAttributes = Maps.newHashMap();
        requestAttributes.put("BOOTER_CONFIG", this.booterConfig);
        this.registeredProxies.put(clazz, ProxyFactory.create(clazz, (URI)ProxyFactory.createUri((String)url), (ClientExecutor)clientExecutor, (ResteasyProviderFactory)ResteasyProviderFactory.getInstance(), (EntityExtractorFactory)new DeployitEntityExtractorFactory(), (Map)requestAttributes));
    }

    private static Iterable<Class<?>> allProxies() {
        return Lists.newArrayList((Object[])new Class[]{ServerService.class, MetadataService.class, RepositoryService.class, ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class, ConfigurationService.class, PermissionService.class, RoleService.class, TaskService.class, TaskBlockService.class, UserService.class});
    }

    public <T> T getProxyInstance(Class<T> clazz) {
        return (T)this.registeredProxies.get(clazz);
    }

    public ServerService getServerService() {
        return this.getProxyInstance(ServerService.class);
    }

    public MetadataService getMetadataService() {
        return this.getProxyInstance(MetadataService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.getProxyInstance(RepositoryService.class);
    }

    public ControlService getControlService() {
        return this.getProxyInstance(ControlService.class);
    }

    public DeploymentService getDeploymentService() {
        return this.getProxyInstance(DeploymentService.class);
    }

    public InspectionService getInspectionService() {
        return this.getProxyInstance(InspectionService.class);
    }

    public PackageService getPackageService() {
        return new StreamingImportingService(this.httpClientHolder, this.booterConfig, this);
    }

    public PermissionService getPermissionService() {
        return this.getProxyInstance(PermissionService.class);
    }

    public RoleService getRoleService() {
        return this.getProxyInstance(RoleService.class);
    }

    public TaskService getTaskService() {
        return this.getProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockService() {
        return this.getProxyInstance(TaskBlockService.class);
    }

    public UserService getUserService() {
        return this.getProxyInstance(UserService.class);
    }

    public static Proxies reinitialize(Proxies oldProxies, HttpClientHolder httpClientHolder, BooterConfig config) {
        Proxies newProxies = new Proxies(httpClientHolder, config);
        if (oldProxies == null) {
            return newProxies;
        }
        for (Class<?> proxyClass : oldProxies.registeredProxies.keySet()) {
            if (newProxies.registeredProxies.containsKey(proxyClass)) continue;
            newProxies.registerProxy(config.getUrl(), proxyClass);
        }
        return newProxies;
    }
}

