/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.xltype.serialization.xstream.AbstractBlockConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = BlockState.class, tagName = "block")
public class BlockConverter extends AbstractBlockConverter {

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {

        final BlockReader blockReader;

        if (reader.getAttribute("root") != null) {
            blockReader = new RemotePhaseContainerReader(reader, context);

        } else if (reader.getAttribute("phase") != null) {
            blockReader = new RemotePhaseReader(reader, context);

        } else if (reader.getAttribute("current") != null) {
            blockReader = new RemoteStepBlockReader(reader, context);

        } else if (reader.getAttribute("parallel") != null) {
            blockReader = new RemoteCompositeBlockReader(reader, context);

        } else {
            blockReader = new RemoteBlockReader(reader);
        }

        return blockReader.read();
    }


}
