/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.client;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.engine.api.dto.ImportFromUrlParams;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitRemoteClient {
    private static final Logger logger = LoggerFactory.getLogger(DeployitRemoteClient.class);
    private final DeployitCommunicator communicator;

    public DeployitRemoteClient(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public ConfigurationItem importPackage(String path, String user, String password) {
        try {
            URL url = new URL(path);
            if (url.getProtocol().equals("file")) {
                return this.importPackage(new File(url.getFile()));
            }
            return this.communicator.getProxies().getPackageService().fetch(new ImportFromUrlParams(url.toExternalForm(), user, password));
        }
        catch (MalformedURLException e) {
            return this.importPackage(new File(path));
        }
    }

    public ConfigurationItem importPackage(String path) {
        return this.importPackage(path, null, null);
    }

    public ConfigurationItem importPackage(File file) {
        if (!file.isAbsolute() && !file.exists()) {
            return this.communicator.getProxies().getPackageService().importPackage(file.getPath().replace(File.separator, "/"));
        }
        logger.info("Importing dar file " + file.getAbsolutePath());
        try {
            return this.communicator.getProxies().getPackageService().upload(file.getName(), (FileUpload)new StreamingImportingService.LocalFileUpload(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("The file %s does not exist at the given absolute path", file.toString()));
        }
    }
}

