/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitEntityExtractorFactory;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private static final Map<Class<?>, Object> registeredProxies = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);

    public static void init(BooterConfig config) {
        for (Class<?> clazz : Proxies.allProxies()) {
            Proxies.registerProxy(config.getUrl(), clazz);
        }
    }

    public static void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor(HttpClientHolder.httpClient(), HttpClientHolder.httpContext());
        registeredProxies.put(clazz, ProxyFactory.create(clazz, (URI)ProxyFactory.createUri((String)url), (ClientExecutor)clientExecutor, (ResteasyProviderFactory)ResteasyProviderFactory.getInstance(), (EntityExtractorFactory)new DeployitEntityExtractorFactory()));
    }

    private static Iterable<Class<?>> allProxies() {
        return Lists.newArrayList((Object[])new Class[]{ServerService.class, MetadataService.class, RepositoryService.class, ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class, PermissionService.class, RoleService.class, TaskService.class, UserService.class});
    }

    public static <T> T getProxyInstance(Class<T> clazz) {
        return (T)registeredProxies.get(clazz);
    }

    public static ServerService getServerService() {
        return Proxies.getProxyInstance(ServerService.class);
    }

    public static MetadataService getMetadataService() {
        return Proxies.getProxyInstance(MetadataService.class);
    }

    public static RepositoryService getRepositoryService() {
        return Proxies.getProxyInstance(RepositoryService.class);
    }

    public static ControlService getControlService() {
        return Proxies.getProxyInstance(ControlService.class);
    }

    public static DeploymentService getDeploymentService() {
        return Proxies.getProxyInstance(DeploymentService.class);
    }

    public static InspectionService getInspectionService() {
        return Proxies.getProxyInstance(InspectionService.class);
    }

    public static PackageService getPackageService() {
        return Proxies.getProxyInstance(PackageService.class);
    }

    public static PermissionService getPermissionService() {
        return Proxies.getProxyInstance(PermissionService.class);
    }

    public static RoleService getRoleService() {
        return Proxies.getProxyInstance(RoleService.class);
    }

    public static TaskService getTaskService() {
        return Proxies.getProxyInstance(TaskService.class);
    }

    public static UserService getUserService() {
        return Proxies.getProxyInstance(UserService.class);
    }
}

