package com.xebialabs.deployit.booter.remote.resteasy;

import org.jboss.resteasy.annotations.ResponseObject;
import org.jboss.resteasy.client.core.extractors.*;

import javax.ws.rs.core.Response;
import java.lang.reflect.Method;

public class DeployitEntityExtractorFactory extends DefaultEntityExtractorFactory {
    @Override
    public EntityExtractor createExtractor(final Method method) {
        final Class returnType = method.getReturnType();
        if (isVoidReturnType(returnType))
            return createVoidExtractor(true);
        if (returnType.equals(Response.Status.class))
            return createStatusExtractor(true);

        if (Response.class.isAssignableFrom(returnType))
            return createResponseTypeEntityExtractor(method);

        if (returnType.isInterface() && returnType.isAnnotationPresent(ResponseObject.class))
            return new ResponseObjectProxy(method, new ResponseObjectEntityExtractorFactory());

        // We are not a ClientResponse type so we need to unmarshall and narrow it
        // to right type. If we are unable to unmarshall, or encounter any kind of
        // Exception, give the ClientErrorHandlers a chance to handle the
        // ClientResponse manually.

        return new DeployitBodyEntityExtractor(method);
    }
}
