package com.xebialabs.deployit.booter.remote.xml;

import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamCiConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(tagName = "configuration-item", readable = ConfigurationItem.class)
public class RemoteXStreamCiConverter extends XStreamCiConverter {

    @Override
    protected ConfigurationItemConverter createConverter() {
        return new RemoteCiConverter();
    }

    private static class RemoteCiConverter extends ConfigurationItemConverter {

        public RemoteCiConverter() {
            setReadValidationMessages(true);
        }

        @Override
        protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            // Store reference directly on the CI as String.
            propertyDescriptor.set(configurationItem, reader.getCiReference());
        }

        @Override
        protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            // Store references directly on the CI as String.
            // For Python's sake, a SET_OF_CI is also stored as a list.
            List<String> references = reader.getCiReferences();
            propertyDescriptor.set(configurationItem, references);
        }

        @Override
        protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            // For Python's sake, a SET_OF_STRING is also stored as a list.
            List<String> strings = reader.getStringValues();
            propertyDescriptor.set(configurationItem, strings);
        }
    }
}
