/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitEntityExtractorFactory;
import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private final DeployitCommunicator communicator;
    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);

    public Proxies(DeployitCommunicator communicator) {
        this.communicator = communicator;
        this.init(communicator.getConfig());
    }

    private void init(BooterConfig config) {
        for (Class<?> clazz : Proxies.allProxies()) {
            this.registerProxy(config.getUrl(), clazz);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor(this.communicator.httpClient(), this.communicator.httpContext());
        this.registeredProxies.put(clazz, ProxyFactory.create(clazz, (URI)ProxyFactory.createUri((String)url), (ClientExecutor)clientExecutor, (ResteasyProviderFactory)ResteasyProviderFactory.getInstance(), (EntityExtractorFactory)new DeployitEntityExtractorFactory()));
    }

    private static Iterable<Class<?>> allProxies() {
        return Lists.newArrayList((Object[])new Class[]{ServerService.class, MetadataService.class, RepositoryService.class, ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class, PermissionService.class, RoleService.class, TaskService.class, UserService.class});
    }

    public <T> T getProxyInstance(Class<T> clazz) {
        return (T)this.registeredProxies.get(clazz);
    }

    public ServerService getServerService() {
        return this.getProxyInstance(ServerService.class);
    }

    public MetadataService getMetadataService() {
        return this.getProxyInstance(MetadataService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.getProxyInstance(RepositoryService.class);
    }

    public ControlService getControlService() {
        return this.getProxyInstance(ControlService.class);
    }

    public DeploymentService getDeploymentService() {
        return this.getProxyInstance(DeploymentService.class);
    }

    public InspectionService getInspectionService() {
        return this.getProxyInstance(InspectionService.class);
    }

    public PackageService getPackageService() {
        return new StreamingImportingService(this.communicator, this);
    }

    public PermissionService getPermissionService() {
        return this.getProxyInstance(PermissionService.class);
    }

    public RoleService getRoleService() {
        return this.getProxyInstance(RoleService.class);
    }

    public TaskService getTaskService() {
        return this.getProxyInstance(TaskService.class);
    }

    public UserService getUserService() {
        return this.getProxyInstance(UserService.class);
    }
}

