/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Monitor;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteDescriptorRegistry;
import com.xebialabs.deployit.booter.remote.resteasy.InternalServerErrorClientResponseInterceptor;
import com.xebialabs.xltype.serialization.xstream.LocalDateStringConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooter {
    private static final Monitor M = new Monitor();
    private static final AtomicBoolean BOOTED = new AtomicBoolean(false);
    private static final Map<BooterConfig, DeployitCommunicator> COMMUNICATORS = Maps.newConcurrentMap();
    private static ResteasyDeployment resteasyDeployment;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployitCommunicator boot(BooterConfig config) {
        if (!BOOTED.get()) {
            M.enter();
            try {
                RemoteBooter.doBoot(config);
            }
            finally {
                M.leave();
            }
        }
        return RemoteBooter.getCommunicator(config);
    }

    private static void doBoot(BooterConfig config) {
        if (!BOOTED.get()) {
            Scannit.boot((Configuration)Configuration.config().scan("com.xebialabs").scan("ext.deployit").with(new AbstractScanner[]{new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()}));
            RemoteBooter.bootResteasy();
            DeployitCommunicator communicator = new DeployitCommunicator(config);
            COMMUNICATORS.put(config, communicator);
            RemoteDescriptorRegistry.boot(communicator);
            XStreamReaderWriter.registerConfigurationItemAliases();
            BOOTED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployitCommunicator getCommunicator(BooterConfig config) {
        if (!BOOTED.get()) {
            throw new IllegalStateException("Should first boot the RemoteBooter.");
        }
        if (!COMMUNICATORS.containsKey(config)) {
            M.enter();
            try {
                if (!COMMUNICATORS.containsKey(config)) {
                    COMMUNICATORS.put(config, new DeployitCommunicator(config));
                }
            }
            finally {
                M.leave();
            }
        }
        return COMMUNICATORS.get(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        M.enter();
        try {
            if (BOOTED.get()) {
                for (BooterConfig config : Sets.newHashSet(COMMUNICATORS.keySet())) {
                    COMMUNICATORS.get(config).shutdown();
                }
                resteasyDeployment.stop();
                BOOTED.set(false);
            }
        }
        finally {
            M.leave();
        }
    }

    private static void bootResteasy() {
        resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.getProviderClasses().add(XStreamReaderWriter.class.getName());
        resteasyDeployment.getProviderClasses().add(LocalDateStringConverter.class.getName());
        resteasyDeployment.start();
        resteasyDeployment.getProviderFactory().addClientErrorInterceptor((ClientErrorInterceptor)new InternalServerErrorClientResponseInterceptor());
    }

    static void remove(BooterConfig config) {
        COMMUNICATORS.remove(config);
    }

    static {
        logger = LoggerFactory.getLogger(RemoteBooter.class);
    }
}

