/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.DataHolder;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.booter.remote.xml.adapter.CiPropertyAdapter;
import com.xebialabs.deployit.booter.remote.xml.adapter.OrchestratorPropertyAdapter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamCiConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;

@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class RemoteXStreamCiConverter
extends XStreamCiConverter {
    private List<CiPropertyAdapter> propertyAdapters = Lists.newArrayList((Object[])new CiPropertyAdapter[]{new OrchestratorPropertyAdapter()});

    protected ConfigurationItemConverter createConverter(DataHolder context) {
        return new RemoteCiConverter(context, this.propertyAdapters);
    }

    public void setPropertyAdapters(List<CiPropertyAdapter> propertyAdapters) {
        this.propertyAdapters = propertyAdapters;
    }

    private static class RemoteCiConverter
    extends ConfigurationItemConverter {
        private DataHolder context;
        private List<CiPropertyAdapter> propertyAdapters;

        public RemoteCiConverter(DataHolder context) {
            this(context, Lists.newArrayListWithCapacity((int)0));
        }

        public RemoteCiConverter(DataHolder context, List<CiPropertyAdapter> propertyAdapters) {
            this.context = context;
            this.propertyAdapters = propertyAdapters;
            this.setReadValidationMessages(true);
        }

        public Type type(String typeName) {
            DeployitCommunicator communicator = this.getCommunicator();
            return communicator.getType(typeName);
        }

        private DeployitCommunicator getCommunicator() {
            String booterConfigKey = (String)this.context.get((Object)"BOOTER_CONFIG");
            return RemoteBooter.getCommunicator(booterConfigKey);
        }

        protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            propertyDescriptor.set(configurationItem, (Object)reader.getCiReference());
        }

        protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            List references = reader.getCiReferences();
            propertyDescriptor.set(configurationItem, (Object)references);
        }

        protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            List strings = reader.getStringValues();
            propertyDescriptor.set(configurationItem, (Object)strings);
        }

        protected void writeProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiWriter writer, int ciRefsFromLevel) {
            CiPropertyAdapter adapter = this.getAdapter(this.context, configurationItem, propertyDescriptor);
            if (adapter != null) {
                adapter.writeProperty(configurationItem, propertyDescriptor, writer, ciRefsFromLevel);
            } else {
                super.writeProperty(configurationItem, propertyDescriptor, writer, ciRefsFromLevel);
            }
        }

        protected void readProperty(CiReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(reader.getCurrentPropertyName());
            CiPropertyAdapter adapter = this.getAdapter(this.context, configurationItem, propertyDescriptor);
            if (adapter != null) {
                adapter.readProperty(reader, propertyDescriptor, configurationItem);
            } else {
                super.readProperty(reader, descriptor, configurationItem);
            }
        }

        private CiPropertyAdapter getAdapter(final DataHolder context, final ConfigurationItem configurationItem, final PropertyDescriptor propertyDescriptor) {
            return (CiPropertyAdapter)Iterables.find(this.propertyAdapters, (Predicate)new Predicate<CiPropertyAdapter>(){

                public boolean apply(CiPropertyAdapter input) {
                    return input.isApplicable(context, configurationItem, propertyDescriptor);
                }
            }, null);
        }
    }
}

