package com.xebialabs.deployit.engine.unicode;

import java.io.IOException;
import java.io.InputStreamReader;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;

public class DetectBOM {

    private DetectBOM() {
    }

    public static BOM detect(TFile file) throws IOException {
        InputStreamReader reader = null;
        try {
            // use 8 bit clean decoder to read first bytes
            reader = new TFileReader(file, Charsets.ISO_8859_1.newDecoder());
            int value = reader.read();
            if (value == 0xef) {
                if (reader.read() == 0xBB && reader.read() == 0xBF) {
                    return BOM.UTF8;
                }
            } else if (value == 0xFE) {
                if (reader.read() == 0xFF) {
                    return BOM.UTF16BE;
                }
            } else if (value == 0xFF) {
                if (reader.read() == 0xFE) {
                    return BOM.UTF16LE;
                }
            }
            return BOM.NONE;
        } finally {
            Closeables.closeQuietly(reader);
        }
    }
}
