package com.xebialabs.deployit.engine.tasker;

import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

@Component
public class Registry {
    private ConcurrentMap<String, TaskRunner> reg = new ConcurrentHashMap<String, TaskRunner>();

    void register(TaskRunner task) {
        String id = task.getTask().getId();
        checkArgument(id != null, "task ID should have been set.");
        checkState(reg.putIfAbsent(id, task) == null, "Task with ID [%s] has already been registered.", id);
    }

    public TaskRunner retrieve(String id) {
        if (!reg.containsKey(id)) {
            throw new TaskNotFoundException("registry", id);
        }
        return reg.get(id);
    }

    public void remove(String id) {
        reg.remove(id);
    }

    public Collection<TaskRunner> tasks() {
        return reg.values();
    }

    public boolean hasTasks() {
        return !reg.isEmpty();
    }

    void clean() {
        reg.clear();
    }
}
