package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;

final class TaskEvent implements TaskExecutionStateEvent {
    private TaskExecutionState previousState;
    private TaskExecutionState currentState;
    private TaskWithSteps task;

    TaskEvent(TaskExecutionState previousState, TaskExecutionState currentState, TaskWithSteps task) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.task = task;
    }

    static TaskEvent taskEvent(TaskWithSteps task, TaskExecutionState newState) {
        return new TaskEvent(task.getState(), newState, task);
    }

    @Override
    public TaskExecutionState previousState() {
        return previousState;
    }

    @Override
    public TaskExecutionState currentState() {
        return currentState;
    }

    @Override
    public TaskWithSteps task() {
        return task;
    }

    @Override
    public String toString() {
        return String.format("TaskEvent[%s: %s -> %s]", task.getId(), previousState, currentState);
    }
}
