/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStep
implements StepState,
Serializable {
    public static final String ERROR_PREFIX = "[ERROR]: ";
    private final Step implementation;
    private final Map<String, String> metadata = Maps.newHashMap();
    private volatile StepExecutionState state;
    private AtomicInteger failureCount;
    private StringBuilder logBuilder;
    private DateTime startDate;
    private DateTime completionDate;
    private DateTime lastModificationDate;
    static final Logger logger = LoggerFactory.getLogger(TaskStep.class);

    public TaskStep(Step step) {
        this.implementation = step;
        this.state = StepExecutionState.PENDING;
        this.failureCount = new AtomicInteger();
        this.logBuilder = new StringBuilder();
    }

    public Step getImplementation() {
        return this.implementation;
    }

    void setState(StepExecutionState state) {
        this.state = state;
        if (state == StepExecutionState.FAILED) {
            this.failureCount.incrementAndGet();
        }
        this.touch();
    }

    void recordStart() {
        this.startDate = new DateTime();
        this.touch();
    }

    void recordCompletion() {
        this.completionDate = new DateTime();
        this.touch();
    }

    void clearLog() {
        this.logBuilder.setLength(0);
    }

    private void touch() {
        this.lastModificationDate = new DateTime();
    }

    public boolean isMarkedForSkip() {
        return this.getState() == StepExecutionState.SKIP;
    }

    public boolean canSkip() {
        return this.getState() == StepExecutionState.PENDING || this.getState() == StepExecutionState.FAILED;
    }

    public String toString() {
        return "[" + this.implementation.getDescription() + "]";
    }

    public StepExecutionState getState() {
        return this.state;
    }

    public String getLog() {
        return this.logBuilder.toString();
    }

    public String getDescription() {
        return this.implementation.getDescription();
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public DateTime getLastModificationDate() {
        return this.lastModificationDate;
    }

    public int getFailureCount() {
        return this.failureCount.intValue();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    ExecutionContext getContext(TaskExecutionContext ctx) {
        return new TaskStepExecutionContext(ctx);
    }

    public boolean isFailed() {
        return this.getState() == StepExecutionState.FAILED;
    }

    class TaskStepExecutionContext
    implements ExecutionContext {
        private TaskExecutionContext taskContext;
        private Logger stepLogger;

        TaskStepExecutionContext(TaskExecutionContext taskContext) {
            this.taskContext = taskContext;
            this.stepLogger = LoggerFactory.getLogger(TaskStep.this.implementation.getClass());
        }

        public synchronized void logOutput(String output) {
            this.stepLogger.info(output);
            TaskStep.this.logBuilder.append(output).append("\n");
            TaskStep.this.touch();
        }

        public synchronized void logError(String error) {
            this.stepLogger.error(error);
            this.appendErrorToLog(error);
            TaskStep.this.touch();
        }

        public synchronized void logError(String error, Throwable t) {
            this.stepLogger.error(error, t);
            this.appendErrorToLog(error);
            StringWriter stringWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(stringWriter));
            for (String stackTraceLine : stringWriter.toString().split("\n")) {
                this.appendErrorToLog(stackTraceLine);
            }
            TaskStep.this.touch();
        }

        private void appendErrorToLog(String error) {
            TaskStep.this.logBuilder.append(TaskStep.ERROR_PREFIX).append(error).append("\n");
        }

        public Object getAttribute(String name) {
            Object object = this.taskContext.getAttribute(name);
            this.stepLogger.debug("Getting value of attribute {}: {}", (Object)name, object);
            return object;
        }

        public void setAttribute(String name, Object object) {
            this.stepLogger.debug("Setting value of attribute {}: {}", (Object)name, object);
            this.taskContext.setAttribute(name, object);
        }

        public Repository getRepository() {
            return this.taskContext.getRepository();
        }

        public InspectionContext getInspectionContext() {
            return this.taskContext.getInspectionContext();
        }
    }
}

