/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.DeploymentPlannerFactory;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.engine.replacer.PlaceholderReplacer;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.test.deployment.InMemoryRepository;
import com.xebialabs.deployit.test.deployment.SimpleReplacer;
import com.xebialabs.deployit.test.support.LoggingExecutionContext;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.deployit.test.support.TestInspectionContext;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitTester {
    private final DeploymentPlanner planner;
    private final Inspector inspector;
    private final InMemoryRepository repository;
    private static final Logger planLogger = LoggerFactory.getLogger(Plan.class);

    public DeployitTester() {
        this.repository = new InMemoryRepository();
        this.planner = new DeploymentPlannerFactory().planner((ReadOnlyRepository)this.repository);
        this.inspector = new Inspector();
    }

    public DeployitTester(DeploymentPlanner planner, Inspector inspector, InMemoryRepository repository) {
        this.planner = planner;
        this.inspector = inspector;
        this.repository = repository;
    }

    @Deprecated
    public static DeployitTester build() {
        return new DeployitTester();
    }

    public List<Step> resolvePlan(DeltaSpecification spec) {
        return this.resolve(spec).getSteps();
    }

    public Plan resolve(DeltaSpecification spec) {
        Plan plan = this.planner.plan(spec);
        planLogger.info("Generated plan for {}:\n{}\n", (Object)DeployitTester.firstCallerOnStack("com.xebialabs"), (Object)plan.writePlan((Writer)new StringWriter()));
        return plan;
    }

    private static String firstCallerOnStack(String packagePrefix) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement frame = stackTrace[i];
            if (!frame.getClassName().startsWith(packagePrefix)) continue;
            return frame.getMethodName();
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<ConfigurationItem> inspect(ConfigurationItem item) {
        LoggingExecutionContext ctx = new LoggingExecutionContext(DeployitTester.class);
        try {
            List<ConfigurationItem> list = this.inspect(item, ctx);
            return list;
        }
        finally {
            ctx.destroy();
        }
    }

    @Deprecated
    public List<ConfigurationItem> inspect(ConfigurationItem item, com.xebialabs.deployit.plugin.api.execution.ExecutionContext ctx) {
        return this.inspector.inspect(item, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> runInspectionTask(ConfigurationItem item) {
        TestExecutionContext executionContext = new TestExecutionContext();
        try {
            List<ConfigurationItem> list = this.runInspectionTask(item, executionContext);
            return list;
        }
        finally {
            executionContext.destroy();
        }
    }

    public List<ConfigurationItem> runInspectionTask(ConfigurationItem item, TestExecutionContext executionContext) {
        TestInspectionContext inspectionContext = executionContext.getInspectionContext();
        Inspector.inspect((ConfigurationItem)item, (InspectionContext)inspectionContext);
        StepExitCode result = this.executePlan(inspectionContext.getSteps(), executionContext);
        if (result == StepExitCode.FAIL) {
            throw new DeployitTesterException("Inspection of " + item + " failed.", new Object[0]);
        }
        return new ArrayList<ConfigurationItem>(inspectionContext.getInspected().values());
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType) {
        return this.generateDeployed(d, c, deployedType, null);
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType, Map<String, String> placeholders) {
        Descriptor deployed = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed configurationItem = (Deployed)deployed.newInstance();
        configurationItem.setDeployable(d);
        configurationItem.setContainer(c);
        configurationItem.setId(c.getId() + "/" + DeployitTester.substringAfterLastSlash(d.getId()));
        Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)d.getType());
        for (PropertyDescriptor propertyDescriptor : deployed.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            PropertyDescriptor deployablePropertyDescriptor = deployableDescriptor.getPropertyDescriptor(name);
            if (deployablePropertyDescriptor == null) continue;
            if (propertyDescriptor.getName().equals("placeholders")) {
                propertyDescriptor.set((ConfigurationItem)configurationItem, (Object)Maps.newHashMap());
                continue;
            }
            propertyDescriptor.set((ConfigurationItem)configurationItem, deployablePropertyDescriptor.get((ConfigurationItem)d));
        }
        if (configurationItem instanceof DerivedArtifact) {
            DerivedArtifact da = (DerivedArtifact)configurationItem;
            if (placeholders != null) {
                da.setPlaceholders(placeholders);
            }
            Placeholders.replacePlaceholders((DerivedArtifact)da, (PlaceholderReplacer)new SimpleReplacer());
        }
        return configurationItem;
    }

    private static String substringAfterLastSlash(String id) {
        int i = id.lastIndexOf(47);
        if (i > -1) {
            return id.substring(i + 1);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode executePlan(List<Step> plan) {
        TestExecutionContext ctx = new TestExecutionContext(this.getClass());
        try {
            StepExitCode stepExitCode = this.executePlan(plan, ctx);
            return stepExitCode;
        }
        finally {
            ctx.destroy();
        }
    }

    public StepExitCode executePlan(List<Step> steps, ExecutionContext context) {
        StepExitCode result = StepExitCode.PAUSE;
        try {
            for (int i = 0; i < steps.size() && (result = steps.get(i).execute(context)) != StepExitCode.FAIL; ++i) {
            }
            return result;
        }
        catch (Exception e) {
            throw new DeployitTesterException(e);
        }
    }

    public InMemoryRepository getRepository() {
        return this.repository;
    }

    public static class DeployitTesterException
    extends RuntimeException {
        DeployitTesterException(String message, Object ... params) {
            super(String.format(message, params));
        }

        DeployitTesterException(Exception e) {
            super(e);
        }
    }
}

