/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ItestTopology {
    private String id;
    private boolean enabledByDefault = false;
    private Map<String, ConfigurationItem> items = Maps.newHashMap();
    private List<Container> targets = Lists.newArrayList();
    private Map<String, Map<String, String>> targetProperties = Maps.newHashMap();
    private Map<String, String> placeholders = Maps.newHashMap();

    private ItestTopology(Element topologyElement) {
        this.init(topologyElement);
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public String getId() {
        return this.id;
    }

    public List<Container> getTargets() {
        return this.targets;
    }

    public Map<String, ConfigurationItem> getItems() {
        return this.items;
    }

    public String replacePlaceholders(String template) {
        for (String placeholder : this.placeholders.keySet()) {
            template = template.replace("${" + placeholder + "}", this.placeholders.get(placeholder));
        }
        return template;
    }

    public Map<String, String> getTargetProperties(String targetId) {
        Map<String, String> props = this.targetProperties.get(targetId);
        if (props == null) {
            props = Collections.emptyMap();
        }
        return props;
    }

    public String getTargetProperty(String targetId, String propertyName) {
        Map<String, String> props = this.targetProperties.get(targetId);
        if (props != null) {
            return props.get(propertyName);
        }
        return null;
    }

    public boolean hasMatchingTarget(Type type) {
        for (Container target : this.targets) {
            if (!target.getType().instanceOf(type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCi(Type type) {
        for (ConfigurationItem item : this.items.values()) {
            if (!item.getType().instanceOf(type)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationItem findFirstMatchingCi(Type type) {
        for (ConfigurationItem item : this.items.values()) {
            if (!item.getType().instanceOf(type)) continue;
            return item;
        }
        throw new RuntimeException("Cannot resolve type " + type + " to a configuration item in the topology");
    }

    public Container findFirstMatchingTarget(Type type) {
        for (Container target : this.targets) {
            if (!target.getType().instanceOf(type)) continue;
            return target;
        }
        throw new RuntimeException("Cannot resolve type " + type + " to a container in the topology");
    }

    public static boolean isItestEnabled(String itestName, boolean defaultValue) {
        String enabledItestsSpecification = System.getProperty("itests");
        if (Strings.isBlank((String)enabledItestsSpecification)) {
            return defaultValue;
        }
        Iterable enabledItests = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).split((CharSequence)enabledItestsSpecification);
        return Iterables.contains((Iterable)enabledItests, (Object)itestName);
    }

    public static Map<String, ItestTopology> load() throws URISyntaxException, JDOMException, IOException {
        return ItestTopology.load(ItestTopology.getTopologyItestFile());
    }

    public static Map<String, ItestTopology> load(File file) throws JDOMException, IOException {
        HashMap topologies = Maps.newHashMap();
        SAXBuilder sb = new SAXBuilder(false);
        Document topologyXml = sb.build(file);
        List topElements = topologyXml.getRootElement().getChildren("toplogy");
        for (Element topElement : topElements) {
            ItestTopology t = new ItestTopology(topElement);
            topologies.put(t.id, t);
        }
        return topologies;
    }

    private static File getTopologyItestFile() throws URISyntaxException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("ItestTopology.xml");
        Preconditions.checkNotNull((Object)url);
        return new File(url.toURI());
    }

    private void init(Element topologyElement) {
        this.id = (String)Preconditions.checkNotNull((Object)topologyElement.getAttributeValue("id"));
        String enabledString = topologyElement.getAttributeValue("enableByDefault");
        this.enabledByDefault = enabledString != null && enabledString.equals("true");
        List ciElements = topologyElement.getChild("configurationItems").getChildren();
        for (Element ciElement : ciElements) {
            this.registerCi(ciElement);
        }
        List targetElements = topologyElement.getChild("targets").getChildren();
        for (Element targetElement : targetElements) {
            this.registerTarget(targetElement);
        }
        List placeholderElements = topologyElement.getChild("placeholders").getChildren();
        for (Element pElement : placeholderElements) {
            this.placeholders.put(pElement.getName(), ((String)Preconditions.checkNotNull((Object)pElement.getValue())).trim());
        }
        this.resolveParentChildRelationships();
    }

    private void resolveParentChildRelationships() {
        for (ConfigurationItem item : this.items.values()) {
            this.resolveParentChildRelationship(item);
        }
    }

    private void registerTarget(Element targetElement) {
        ConfigurationItem target = this.resolveCiReference((String)Preconditions.checkNotNull((Object)targetElement.getAttributeValue("id"), (Object)"id is required for target element"), targetElement.getName());
        Descriptor d = DescriptorRegistry.getDescriptor((Type)target.getType());
        Preconditions.checkArgument((boolean)d.isAssignableTo(Container.class), (String)"Type [%s] is not assignable to udm.Container", (Object[])new Object[]{d.getType()});
        this.targets.add((Container)target);
        for (Element p : targetElement.getChildren()) {
            if (!this.targetProperties.containsKey(target.getId())) {
                this.targetProperties.put(target.getId(), new HashMap());
            }
            Map<String, String> props = this.targetProperties.get(target.getId());
            props.put(p.getName(), ((String)Preconditions.checkNotNull((Object)p.getValue())).trim());
        }
    }

    private void registerCi(Element ciElement) {
        Descriptor d = DescriptorRegistry.getDescriptor((String)ciElement.getName());
        ConfigurationItem item = d.newInstance();
        item.setId((String)Preconditions.checkNotNull((Object)ciElement.getAttributeValue("id"), (String)"Element [%s] has no id attribute", (Object[])new Object[]{ciElement.getName()}));
        block6: for (Element p : ciElement.getChildren()) {
            PropertyDescriptor pd = (PropertyDescriptor)Preconditions.checkNotNull((Object)d.getPropertyDescriptor(p.getName()), (String)"Property [%s.%s] does not exist", (Object[])new Object[]{d.getType(), p.getName()});
            switch (pd.getKind()) {
                case CI: {
                    pd.set(item, (Object)this.resolveCiReference(p));
                    continue block6;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    for (Element e : p.getChildren("entry")) {
                        map.put(Preconditions.checkNotNull((Object)e.getAttributeValue("key")), Preconditions.checkNotNull((Object)e.getValue()));
                    }
                    pd.set(item, (Object)map);
                    continue block6;
                }
                case SET_OF_STRING: {
                    HashSet setOfString = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfString.add(v.getValue());
                    }
                    pd.set(item, (Object)setOfString);
                    continue block6;
                }
                case SET_OF_CI: {
                    HashSet setOfCi = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfCi.add(this.resolveCiReference(v));
                    }
                    pd.set(item, (Object)setOfCi);
                    continue block6;
                }
            }
            pd.set(item, (Object)p.getValue());
        }
        this.items.put(item.getId(), item);
    }

    private ConfigurationItem resolveCiReference(Element p) {
        return this.resolveCiReference(p.getValue(), p.getName());
    }

    private ConfigurationItem resolveCiReference(String id, String elementName) {
        String ciRefId = id.trim();
        ConfigurationItem ciRef = this.items.get(ciRefId);
        return (ConfigurationItem)Preconditions.checkNotNull((Object)ciRef, (String)"Cannot resolve ci ref [%s] for element [%s]", (Object[])new Object[]{ciRefId, elementName});
    }

    private void resolveParentChildRelationship(ConfigurationItem item) {
        Descriptor d = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            boolean isReferenceToParent = pd.getKind() == PropertyKind.CI && pd.isAsContainment();
            if (!isReferenceToParent) continue;
            ConfigurationItem parent = this.getParent(item, pd);
            pd.set(item, (Object)parent);
            for (PropertyDescriptor ppd : parent.getType().getDescriptor().getPropertyDescriptors()) {
                boolean isReferenceToChild = (ppd.getKind() == PropertyKind.SET_OF_CI || ppd.getKind() == PropertyKind.LIST_OF_CI) && ppd.isAsContainment() && d.isAssignableTo(ppd.getReferencedType());
                if (!isReferenceToChild) continue;
                Collection refs = (Collection)ppd.get(parent);
                refs.add(item);
                ppd.set(parent, (Object)refs);
            }
        }
    }

    private ConfigurationItem getParent(ConfigurationItem item, PropertyDescriptor pd) {
        ConfigurationItem parent;
        String parentId = ItestTopology.getParentId(item.getId());
        if (parentId.equals(item.getId())) {
            parent = item;
        } else {
            parent = this.items.get(parentId);
            Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"Cannot resolve parent reference from item [%s] for property [%s]", (Object[])new Object[]{item.getId(), pd});
        }
        return parent;
    }

    private static String getParentId(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        Preconditions.checkArgument((indexOfLastSlash != -1 ? 1 : 0) != 0, (String)"[%s] has no parent", (Object[])new Object[]{id});
        return id.substring(0, indexOfLastSlash);
    }
}

