/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryRepository
implements ReadOnlyRepository {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    public <T extends ConfigurationItem> T read(String id) {
        return (T)this.store.get(id);
    }

    public <T extends ConfigurationItem> List<T> search(Type type, final String parent) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.search(type), (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input.getId().startsWith(parent);
            }
        }));
    }

    public <T extends ConfigurationItem> List<T> search(Type type) {
        ArrayList entities = Lists.newArrayList();
        for (ConfigurationItem configurationItem : this.store.values()) {
            if (!configurationItem.getType().equals((Object)type)) continue;
            entities.add(configurationItem);
        }
        return entities;
    }

    public <T extends ConfigurationItem> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])entities);
        this.storeEntities((ConfigurationItem[])entities);
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            this.store.put(entity.getId(), entity);
        }
    }

    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }
}

