/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.xebialabs.overcast.CloudHost;
import java.util.HashMap;
import java.util.Map;

public class CloudHostRegistry {
    private static final CloudHostRegistry instance = new CloudHostRegistry();
    private Map<String, State> stateByName = new HashMap<String, State>();
    private Map<String, CloudHost> hostByName = new HashMap<String, CloudHost>();

    private CloudHostRegistry() {
    }

    public static CloudHostRegistry getInstance() {
        return instance;
    }

    public void makeSureIsUp(CloudHost cloudHost) {
        if (State.UP.equals((Object)this.stateByName.get(cloudHost.getHostName()))) {
            return;
        }
        cloudHost.setup();
        this.stateByName.put(cloudHost.getHostName(), State.UP);
        this.hostByName.put(cloudHost.getHostName(), cloudHost);
    }

    public void makeSureIsDown(CloudHost cloudHost) {
        if (!State.UP.equals((Object)this.stateByName.get(cloudHost.getHostName()))) {
            return;
        }
        cloudHost.teardown();
        this.stateByName.put(cloudHost.getHostName(), State.DOWN);
        this.hostByName.put(cloudHost.getHostName(), cloudHost);
    }

    public synchronized void makeSureAllAreDown() {
        for (Map.Entry<String, State> stringStateEntry : this.stateByName.entrySet()) {
            if (!State.UP.equals((Object)stringStateEntry.getValue())) continue;
            this.hostByName.get(stringStateEntry.getKey()).teardown();
            this.stateByName.put(stringStateEntry.getKey(), State.DOWN);
        }
    }

    public void makeSureAllDownInTheEnd() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CloudHostRegistry.this.makeSureAllAreDown();
            }
        });
    }

    public void reset() {
        this.stateByName = new HashMap<String, State>();
        this.hostByName = new HashMap<String, CloudHost>();
    }

    private static enum State {
        UP,
        DOWN;

    }
}

