/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.test.support.ItestTopology;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public class DeployedItestChangeSet {
    private DeployMode deployMode = DeployMode.CREATE;
    private Map<String, Deployed> create = Maps.newLinkedHashMap();
    private Map<String, Deployed> modify = Maps.newLinkedHashMap();
    private List<Type> additionalTypesToDiscover = Lists.newArrayList();
    private Set<PropertyDescriptor> requiredForInspection = Sets.newHashSet();
    private File changesetXmlFile;
    private Container container;
    private ItestTopology topology;
    private TemporaryFolder folder;

    protected DeployedItestChangeSet(File changesetXmlFile, Container container, ItestTopology topology, TemporaryFolder folder) {
        this.changesetXmlFile = changesetXmlFile;
        this.container = container;
        this.topology = topology;
        this.folder = folder;
    }

    public static DeployedItestChangeSet loadChangeSet(File changesetXmlFile, Container container, ItestTopology topology, TemporaryFolder folder) throws JDOMException, IOException {
        DeployedItestChangeSet cs = new DeployedItestChangeSet(changesetXmlFile, container, topology, folder);
        cs.init();
        return cs;
    }

    protected void init() throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document deployedProperties = sb.build(this.changesetXmlFile);
        Element rootElement = deployedProperties.getRootElement();
        this.setDeployMode(rootElement.getAttributeValue("deployMode"));
        String disableInTopology = rootElement.getAttributeValue("disableInTopology");
        if (Strings.isNotBlank((String)disableInTopology)) {
            Iterable searchTags = Splitter.on((char)',').trimResults().split((CharSequence)disableInTopology);
            if (!this.topology.getTags().isEmpty()) {
                for (String searchTag : searchTags) {
                    if (!this.topology.getTags().contains(searchTag)) continue;
                    return;
                }
            }
        }
        List deployedGroupElements = rootElement.getChildren("deployeds");
        for (Element deployedGroupElement : deployedGroupElements) {
            String additionalTypes = deployedGroupElement.getAttributeValue("additionalTypesToDiscover");
            if (Strings.isNotBlank((String)additionalTypes)) {
                for (String t : additionalTypes.split(",")) {
                    this.addAdditionalTypeToDiscover(t);
                }
            }
            String target = deployedGroupElement.getAttributeValue("target");
            Container targetContainer = this.container;
            if (target != null) {
                Type containerType = Type.valueOf((String)target);
                if (!this.container.getType().instanceOf(containerType)) {
                    boolean alwaysDeployToTarget = "true".equals(deployedGroupElement.getAttributeValue("alwaysDeployToTarget"));
                    if (!alwaysDeployToTarget) continue;
                    targetContainer = this.topology.findFirstMatchingTarget(containerType);
                }
            }
            List deployedElements = deployedGroupElement.getChildren();
            File deployedFolder = this.folder.newFolder();
            for (Element each : deployedElements) {
                this.convertDeployedElementToDeployed(each, targetContainer, deployedFolder);
            }
        }
        this.associateDeployedIdsWithContainer();
    }

    private void convertDeployedElementToDeployed(Element deployedElement, Container targetContainer, File deployedFolder) throws IOException {
        Descriptor d = DescriptorRegistry.getDescriptor((String)deployedElement.getName());
        Preconditions.checkArgument((boolean)d.isAssignableTo(Deployed.class), (String)"Type [%s] is not assignable to udm.Deployed", (Object[])new Object[]{d.getType()});
        Deployed item = (Deployed)d.newInstance();
        if (item instanceof Artifact) {
            Element fileNameElm = deployedElement.getChild("fileName");
            Preconditions.checkArgument((fileNameElm != null ? 1 : 0) != 0, (String)"Type [%s] is an artifact and must specify fileName that can be resolved from the classpath", (Object[])new Object[]{d.getType()});
            File artifact = new File(deployedFolder, OverthereUtils.getName((String)fileNameElm.getValue()));
            Assert.assertThat((String)("Artifact " + artifact + " should not yet exist"), (Object)artifact.exists(), (Matcher)CoreMatchers.equalTo((Object)false));
            URL aURL = this.getClass().getClassLoader().getResource(fileNameElm.getValue());
            Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)aURL), (File)artifact);
            ((Artifact)item).setFile(LocalFile.valueOf((File)artifact));
        }
        item.setId((String)Preconditions.checkNotNull((Object)deployedElement.getAttributeValue("id"), (String)"Element [%s] has no id attribute", (Object[])new Object[]{deployedElement.getName()}));
        item.setContainer(targetContainer);
        boolean isModification = "true".equals(deployedElement.getAttributeValue("modification"));
        if (isModification) {
            Preconditions.checkArgument((boolean)this.deployedToBeCreatedExists(item.getId()), (String)"Element [%s] has modification='true' but the original deployed with id [%s] could not be found.", (Object[])new Object[]{deployedElement.getName(), item.getId()});
            item = this.cloneDeployed(this.getDeployedToCreate(item.getId()));
        }
        block8: for (Element p : deployedElement.getChildren()) {
            if (p.getName().equals("fileName")) continue;
            PropertyDescriptor pd = (PropertyDescriptor)Preconditions.checkNotNull((Object)d.getPropertyDescriptor(p.getName()), (String)"Property [%s.%s] does not exist", (Object[])new Object[]{d.getType(), p.getName()});
            if (p.getAttributeValue("inspectionProperty") != null && p.getAttributeValue("inspectionProperty").equals("true")) {
                this.requiredForInspection.add(pd);
            }
            switch (pd.getKind()) {
                case CI: {
                    pd.set((ConfigurationItem)item, (Object)this.resolveCiReference(p, pd));
                    continue block8;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    for (Element e : p.getChildren("entry")) {
                        map.put(Preconditions.checkNotNull((Object)e.getAttributeValue("key")), Preconditions.checkNotNull((Object)e.getValue()));
                    }
                    pd.set((ConfigurationItem)item, (Object)map);
                    continue block8;
                }
                case SET_OF_STRING: {
                    HashSet setOfString = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfString.add(v.getValue());
                    }
                    pd.set((ConfigurationItem)item, (Object)setOfString);
                    continue block8;
                }
                case LIST_OF_STRING: {
                    ArrayList listOfString = Lists.newArrayList();
                    for (Element v : p.getChildren("value")) {
                        listOfString.add(v.getValue());
                    }
                    pd.set((ConfigurationItem)item, (Object)listOfString);
                    continue block8;
                }
                case LIST_OF_CI: {
                    ArrayList listOfCi = Lists.newArrayList();
                    for (Element v : p.getChildren("value")) {
                        listOfCi.add(this.resolveCiReference(v, pd));
                    }
                    pd.set((ConfigurationItem)item, (Object)listOfCi);
                    continue block8;
                }
                case SET_OF_CI: {
                    HashSet setOfCi = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfCi.add(this.resolveCiReference(v, pd));
                    }
                    pd.set((ConfigurationItem)item, (Object)setOfCi);
                    continue block8;
                }
            }
            pd.set((ConfigurationItem)item, (Object)p.getValue());
        }
        if (isModification) {
            this.addDeployedToModify(item);
        } else {
            this.addDeployedToCreate(item);
        }
    }

    protected ConfigurationItem resolveCiReference(Element p, PropertyDescriptor pd) {
        String ciRefId = p.getValue().trim();
        if (this.deployedToBeCreatedExists(ciRefId)) {
            return this.getDeployedToCreate(ciRefId);
        }
        ciRefId = this.topology.replacePlaceholders(ciRefId);
        ConfigurationItem ciRef = this.topology.getItems().get(ciRefId);
        if (ciRef == null) {
            ciRef = DescriptorRegistry.getDescriptor((Type)pd.getReferencedType()).newInstance();
            ciRef.setId(ciRefId);
        }
        return ciRef;
    }

    protected void setDeployMode(String deployModeAttribute) {
        if (deployModeAttribute == null) {
            return;
        }
        try {
            this.deployMode = DeployMode.valueOf(deployModeAttribute.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported deployMode value '%s' on itest tag expected [%s]", deployModeAttribute, Joiner.on((String)"|").join((Iterable)Lists.newArrayList((Object[])DeployMode.values()))));
        }
    }

    protected void associateDeployedIdsWithContainer() {
        Iterable deployeds = Iterables.concat(this.getDeployedsToCreate(), this.getDeployedsToModify());
        for (Deployed deployed : deployeds) {
            Preconditions.checkNotNull((Object)deployed.getContainer());
            deployed.setId(deployed.getContainer().getId() + "/" + deployed.getId());
        }
    }

    protected List<Deployed> cloneForInspection(List<Deployed> deployeds) {
        ArrayList clonedDeployeds = Lists.newArrayList();
        for (Deployed deployed : deployeds) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
            Deployed di = (Deployed)descriptor.newInstance();
            Iterable inspectProperties = Iterables.filter((Iterable)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return input.isInspectionProperty() || DeployedItestChangeSet.this.requiredForInspection.contains(input);
                }
            });
            di.setId(deployed.getId());
            di.setDeployable(deployed.getDeployable());
            di.setContainer(deployed.getContainer());
            for (PropertyDescriptor inspectProperty : inspectProperties) {
                inspectProperty.set((ConfigurationItem)di, inspectProperty.get((ConfigurationItem)deployed));
            }
            clonedDeployeds.add(di);
        }
        return clonedDeployeds;
    }

    protected Deployed cloneDeployed(Deployed deployed) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Deployed clonedDeployed = (Deployed)descriptor.newInstance();
        clonedDeployed.setId(deployed.getId());
        clonedDeployed.setDeployable(deployed.getDeployable());
        clonedDeployed.setContainer(deployed.getContainer());
        for (PropertyDescriptor inspectProperty : descriptor.getPropertyDescriptors()) {
            inspectProperty.set((ConfigurationItem)clonedDeployed, inspectProperty.get((ConfigurationItem)deployed));
        }
        return clonedDeployed;
    }

    public DeployMode getDeployMode() {
        return this.deployMode;
    }

    public List<Type> getAdditionalTypesToDiscover() {
        return this.additionalTypesToDiscover;
    }

    public boolean hasDeployedsToCreate() {
        return !this.create.isEmpty();
    }

    public boolean hasDeployedsToModify() {
        return !this.modify.isEmpty();
    }

    public void addAdditionalTypeToDiscover(String type) {
        this.additionalTypesToDiscover.add(Type.valueOf((String)type.trim()));
    }

    public void addDeployedToCreate(Deployed d) {
        this.create.put(d.getId(), d);
    }

    public void addDeployedToModify(Deployed d) {
        this.modify.put(d.getId(), d);
    }

    public Deployed getDeployedToCreate(String id) {
        return this.create.get(id);
    }

    public Deployed getDeployedToModify(String id) {
        return this.modify.get(id);
    }

    public boolean deployedToBeCreatedExists(String id) {
        return this.create.containsKey(id);
    }

    public List<Deployed> getDeployedsToCreate() {
        return Lists.newArrayList(this.create.values());
    }

    public List<Deployed> getDeployedsToModify() {
        return Lists.newArrayList(this.modify.values());
    }

    public static enum DeployMode {
        CREATE,
        UPDATE_ONLY;

    }
}

